/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.utility.shader;

import java.awt.Color;
import keystrokesmod.utility.RenderUtils;
import keystrokesmod.utility.shader.ShaderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class RoundedUtils {
    public static ShaderUtils roundedShader = new ShaderUtils("roundedRect");
    public static ShaderUtils roundedOutlineShader = new ShaderUtils("roundRectOutline");
    private static final ShaderUtils roundedTexturedShader = new ShaderUtils("roundRectTexture");
    private static final ShaderUtils roundedGradientShader = new ShaderUtils("roundedRectGradient");
    private static final ShaderUtils roundedRectRiseShader = new ShaderUtils("roundedRectRise");

    public static void drawRound(float x, float y, float width, float height, float radius, Color color) {
        RoundedUtils.drawRound(x, y, width, height, radius, false, color);
    }

    public static void drawGradientHorizontal(float x, float y, float width, float height, float radius, Color left, Color right) {
        RoundedUtils.drawGradientRound(x, y, width, height, radius, left, left, right, right);
    }

    public static void drawGradientVertical(float x, float y, float width, float height, float radius, Color top, Color bottom) {
        RoundedUtils.drawGradientRound(x, y, width, height, radius, bottom, top, bottom, top);
    }

    public static void drawGradientCornerLR(float x, float y, float width, float height, float radius, Color topLeft, Color bottomRight) {
        Color mixedColor = RenderUtils.interpolateColorC(topLeft, bottomRight, 0.5f);
        RoundedUtils.drawGradientRound(x, y, width, height, radius, mixedColor, topLeft, bottomRight, mixedColor);
    }

    public static void drawGradientCornerRL(float x, float y, float width, float height, float radius, Color bottomLeft, Color topRight) {
        Color mixedColor = RenderUtils.interpolateColorC(topRight, bottomLeft, 0.5f);
        RoundedUtils.drawGradientRound(x, y, width, height, radius, bottomLeft, mixedColor, mixedColor, topRight);
    }

    public static void drawRound(float x, float y, float width, float height, float radius, int color) {
        RoundedUtils.drawRound(x, y, width, height, radius, false, color);
    }

    public static void drawRound(float x, float y, float width, float height, float radius, boolean blur2, int color) {
        RenderUtils.resetColor();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setAlphaLimit(0.0f);
        roundedShader.init();
        RoundedUtils.setupRoundedRectUniforms(x, y, width, height, radius, roundedShader);
        roundedShader.setUniformi("blur", blur2 ? 1 : 0);
        roundedShader.setUniformf("color", RoundedUtils.getRed(color), RoundedUtils.getGreen(color), RoundedUtils.getBlue(color), RoundedUtils.getAlpha(color));
        ShaderUtils.drawQuads(x - 1.0f, y - 1.0f, width + 2.0f, height + 2.0f);
        roundedShader.unload();
        GlStateManager.func_179084_k();
    }

    public static void drawGradientRound(float x, float y, float width, float height, float radius, Color bottomLeft, Color topLeft, Color bottomRight, Color topRight) {
        RenderUtils.setAlphaLimit(0.0f);
        RenderUtils.resetColor();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        roundedGradientShader.init();
        RoundedUtils.setupRoundedRectUniforms(x, y, width, height, radius, roundedGradientShader);
        roundedGradientShader.setUniformf("color1", (float)topLeft.getRed() / 255.0f, (float)topLeft.getGreen() / 255.0f, (float)topLeft.getBlue() / 255.0f, (float)topLeft.getAlpha() / 255.0f);
        roundedGradientShader.setUniformf("color2", (float)bottomLeft.getRed() / 255.0f, (float)bottomLeft.getGreen() / 255.0f, (float)bottomLeft.getBlue() / 255.0f, (float)bottomLeft.getAlpha() / 255.0f);
        roundedGradientShader.setUniformf("color3", (float)topRight.getRed() / 255.0f, (float)topRight.getGreen() / 255.0f, (float)topRight.getBlue() / 255.0f, (float)topRight.getAlpha() / 255.0f);
        roundedGradientShader.setUniformf("color4", (float)bottomRight.getRed() / 255.0f, (float)bottomRight.getGreen() / 255.0f, (float)bottomRight.getBlue() / 255.0f, (float)bottomRight.getAlpha() / 255.0f);
        ShaderUtils.drawQuads(x - 1.0f, y - 1.0f, width + 2.0f, height + 2.0f);
        roundedGradientShader.unload();
        GlStateManager.func_179084_k();
    }

    public static void drawGradientRound(float x, float y, float width, float height, float radius, int bottomLeft, int topLeft, int bottomRight, int topRight) {
        RenderUtils.setAlphaLimit(0.0f);
        RenderUtils.resetColor();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        roundedGradientShader.init();
        RoundedUtils.setupRoundedRectUniforms(x, y, width, height, radius, roundedGradientShader);
        roundedGradientShader.setUniformf("color1", RoundedUtils.getRed(topLeft), RoundedUtils.getGreen(topLeft), RoundedUtils.getBlue(topLeft), RoundedUtils.getAlpha(topLeft));
        roundedGradientShader.setUniformf("color2", RoundedUtils.getRed(bottomLeft), RoundedUtils.getGreen(bottomLeft), RoundedUtils.getBlue(bottomLeft), RoundedUtils.getAlpha(bottomLeft));
        roundedGradientShader.setUniformf("color3", RoundedUtils.getRed(topRight), RoundedUtils.getGreen(topRight), RoundedUtils.getBlue(topRight), RoundedUtils.getAlpha(topRight));
        roundedGradientShader.setUniformf("color4", RoundedUtils.getRed(bottomRight), RoundedUtils.getGreen(bottomRight), RoundedUtils.getBlue(bottomRight), RoundedUtils.getAlpha(bottomRight));
        ShaderUtils.drawQuads(x - 1.0f, y - 1.0f, width + 2.0f, height + 2.0f);
        roundedGradientShader.unload();
        GlStateManager.func_179084_k();
    }

    public static void drawRound(float x, float y, float width, float height, float radius, boolean blur2, Color color) {
        RenderUtils.resetColor();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setAlphaLimit(0.0f);
        roundedShader.init();
        RoundedUtils.setupRoundedRectUniforms(x, y, width, height, radius, roundedShader);
        roundedShader.setUniformi("blur", blur2 ? 1 : 0);
        roundedShader.setUniformf("color", (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        ShaderUtils.drawQuads(x - 1.0f, y - 1.0f, width + 2.0f, height + 2.0f);
        roundedShader.unload();
        GlStateManager.func_179084_k();
    }

    public static void drawRoundOutline(float x, float y, float width, float height, float radius, float outlineThickness, Color color, Color outlineColor) {
        RenderUtils.resetColor();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setAlphaLimit(0.0f);
        roundedOutlineShader.init();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        RoundedUtils.setupRoundedRectUniforms(x, y, width, height, radius, roundedOutlineShader);
        roundedOutlineShader.setUniformf("outlineThickness", outlineThickness * (float)sr.func_78325_e());
        roundedOutlineShader.setUniformf("color", (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        roundedOutlineShader.setUniformf("outlineColor", (float)outlineColor.getRed() / 255.0f, (float)outlineColor.getGreen() / 255.0f, (float)outlineColor.getBlue() / 255.0f, (float)outlineColor.getAlpha() / 255.0f);
        ShaderUtils.drawQuads(x - (2.0f + outlineThickness), y - (2.0f + outlineThickness), width + (4.0f + outlineThickness * 2.0f), height + (4.0f + outlineThickness * 2.0f));
        roundedOutlineShader.unload();
        GlStateManager.func_179084_k();
    }

    public static void drawRoundTextured(float x, float y, float width, float height, float radius, float alpha) {
        RenderUtils.resetColor();
        RenderUtils.setAlphaLimit(0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        roundedTexturedShader.init();
        roundedTexturedShader.setUniformi("textureIn", 0);
        RoundedUtils.setupRoundedRectUniforms(x, y, width, height, radius, roundedTexturedShader);
        roundedTexturedShader.setUniformf("alpha", alpha);
        ShaderUtils.drawQuads(x - 1.0f, y - 1.0f, width + 2.0f, height + 2.0f);
        roundedTexturedShader.unload();
        GlStateManager.func_179084_k();
    }

    private static void setupRoundedRectUniforms(float x, float y, float width, float height, float radius, ShaderUtils roundedTexturedShader) {
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        roundedTexturedShader.setUniformf("location", x * (float)sr.func_78325_e(), (float)Minecraft.func_71410_x().field_71440_d - height * (float)sr.func_78325_e() - y * (float)sr.func_78325_e());
        roundedTexturedShader.setUniformf("rectSize", width * (float)sr.func_78325_e(), height * (float)sr.func_78325_e());
        roundedTexturedShader.setUniformf("radius", radius * (float)sr.func_78325_e());
    }

    public static void drawRoundedRectRise(float x, float y, float width, float height, float radius, int color, boolean leftTop, boolean rightTop, boolean rightBottom, boolean leftBottom) {
        GL11.glPushMatrix();
        GlStateManager.func_179123_a();
        int programId = RoundedUtils.roundedRectRiseShader.programID;
        GL20.glUseProgram((int)programId);
        roundedRectRiseShader.setUniformf("u_size", width, height);
        roundedRectRiseShader.setUniformf("u_radius", radius);
        roundedRectRiseShader.setUniformf("u_color", RoundedUtils.getRed(color), RoundedUtils.getGreen(color), RoundedUtils.getBlue(color), RoundedUtils.getAlpha(color));
        roundedRectRiseShader.setUniformf("u_edges", leftTop ? 1.0f : 0.0f, rightTop ? 1.0f : 0.0f, rightBottom ? 1.0f : 0.0f, leftBottom ? 1.0f : 0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        ShaderUtils.drawQuads(x, y, width, height);
        GlStateManager.func_179084_k();
        GL20.glUseProgram((int)0);
        GlStateManager.func_179099_b();
        GL11.glPopMatrix();
    }

    public static void drawRoundedRectRise(double x, double y, double width, double height, double radius, int color) {
        RoundedUtils.drawRoundedRectRise((float)x, (float)y, (float)width, (float)height, (float)radius, color, true, true, true, true);
    }

    private static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    private static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }
}

