/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.utility.profile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import keystrokesmod.Raven;
import keystrokesmod.clickgui.ClickGui;
import keystrokesmod.clickgui.components.impl.CategoryComponent;
import keystrokesmod.event.PostProfileLoadEvent;
import keystrokesmod.module.Module;
import keystrokesmod.module.ModuleManager;
import keystrokesmod.module.impl.client.Gui;
import keystrokesmod.module.impl.client.Settings;
import keystrokesmod.module.impl.movement.Sprint;
import keystrokesmod.module.impl.render.HUD;
import keystrokesmod.module.impl.render.TargetInfo;
import keystrokesmod.module.setting.Setting;
import keystrokesmod.module.setting.impl.ButtonSetting;
import keystrokesmod.module.setting.impl.KeySetting;
import keystrokesmod.module.setting.impl.SliderSetting;
import keystrokesmod.script.Manager;
import keystrokesmod.utility.Utils;
import keystrokesmod.utility.profile.Profile;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ProfileManager {
    public static Minecraft mc = Minecraft.func_71410_x();
    public File directory;
    public List<Profile> profiles = new ArrayList<Profile>();

    public ProfileManager() {
        boolean success;
        this.directory = new File(ProfileManager.mc.field_71412_D + File.separator + "keystrokes", "profiles");
        if (!this.directory.exists() && !(success = this.directory.mkdirs())) {
            System.out.println("There was an issue creating profiles directory.");
            return;
        }
        if (this.directory.listFiles().length == 0) {
            this.saveProfile(new Profile("default", 0));
        }
    }

    public void saveProfile(Profile profile) {
        JsonObject moduleInformation;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("keybind", (Number)profile.getModule().getKeycode());
        JsonArray jsonArray = new JsonArray();
        for (Module module : Raven.moduleManager.getModules()) {
            if (module.ignoreOnSave) continue;
            moduleInformation = ProfileManager.getJsonObject(module);
            jsonArray.add((JsonElement)moduleInformation);
        }
        if (Raven.scriptManager != null && Raven.scriptManager.scripts != null) {
            for (Module module : Raven.scriptManager.scripts.values()) {
                if (module.ignoreOnSave) continue;
                moduleInformation = ProfileManager.getJsonObject(module);
                jsonArray.add((JsonElement)moduleInformation);
            }
        }
        jsonObject.add("modules", (JsonElement)jsonArray);
        try (FileWriter fileWriter = new FileWriter(new File(this.directory, profile.getName() + ".json"));){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
        }
        catch (Exception e) {
            this.failedMessage("save", profile.getName());
            e.printStackTrace();
        }
    }

    private static JsonObject getJsonObject(Module module) {
        JsonObject moduleInformation = new JsonObject();
        moduleInformation.addProperty("name", module.moduleCategory() == Module.category.scripts && !(module instanceof Manager) ? "sc-" + module.getName() : module.getName());
        if (module.canBeEnabled) {
            moduleInformation.addProperty("enabled", Boolean.valueOf(module.isEnabled()));
            moduleInformation.addProperty("hidden", Boolean.valueOf(module.isHidden()));
            moduleInformation.addProperty("keybind", (Number)module.getKeycode());
        }
        if (module instanceof HUD) {
            moduleInformation.addProperty("posX", (Number)HUD.posX);
            moduleInformation.addProperty("posY", (Number)HUD.posY);
        } else if (module instanceof TargetInfo) {
            moduleInformation.addProperty("posX", (Number)ModuleManager.targetInfo.posX);
            moduleInformation.addProperty("posY", (Number)ModuleManager.targetInfo.posY);
        } else if (module instanceof Sprint) {
            moduleInformation.addProperty("posX", (Number)Float.valueOf(ModuleManager.sprint.posX));
            moduleInformation.addProperty("posY", (Number)Float.valueOf(ModuleManager.sprint.posY));
            moduleInformation.addProperty("text", ModuleManager.sprint.text);
        } else if (module instanceof Gui) {
            for (CategoryComponent c : ClickGui.categories) {
                moduleInformation.addProperty(c.category.name(), c.x + "," + c.y + "," + c.opened);
            }
        }
        for (Setting setting : module.getSettings()) {
            if (setting instanceof ButtonSetting && !((ButtonSetting)setting).isMethodButton) {
                moduleInformation.addProperty(setting.getName(), Boolean.valueOf(((ButtonSetting)setting).isToggled()));
                continue;
            }
            if (setting instanceof SliderSetting) {
                moduleInformation.addProperty(setting.getName(), (Number)((SliderSetting)setting).getInput());
                continue;
            }
            if (!(setting instanceof KeySetting)) continue;
            moduleInformation.addProperty(setting.getName(), (Number)((KeySetting)setting).getKey());
        }
        return moduleInformation;
    }

    public void loadProfile(String name) {
        for (File file : this.getProfileFiles()) {
            if (!file.exists()) {
                this.failedMessage("load", name);
                System.out.println("Failed to load " + name);
                return;
            }
            if (!file.getName().equals(name + ".json")) continue;
            if (Raven.scriptManager != null) {
                for (Module module : Raven.scriptManager.scripts.values()) {
                    if (!module.canBeEnabled()) continue;
                    module.disable();
                    module.setBind(0);
                }
            }
            for (Module module : Raven.getModuleManager().getModules()) {
                if (!module.canBeEnabled()) continue;
                module.disable();
                module.setBind(0);
            }
            try {
                FileReader fileReader = new FileReader(file);
                Throwable throwable = null;
                try {
                    JsonParser jsonParser = new JsonParser();
                    JsonObject profileJson = jsonParser.parse((Reader)fileReader).getAsJsonObject();
                    if (profileJson == null) {
                        this.failedMessage("load", name);
                        return;
                    }
                    JsonArray modules2 = profileJson.getAsJsonArray("modules");
                    if (modules2 == null) {
                        this.failedMessage("load", name);
                        return;
                    }
                    boolean currentProfileGuiSave = Settings.loadGuiPositions.isToggled();
                    for (JsonElement moduleJson : modules2) {
                        JsonObject moduleInformation = moduleJson.getAsJsonObject();
                        String moduleName = moduleInformation.get("name").getAsString();
                        if (moduleName == null || moduleName.isEmpty()) continue;
                        Module module = Raven.moduleManager.getModule(moduleName);
                        if (module == null && moduleName.startsWith("sc-") && Raven.scriptManager != null) {
                            for (Module module2 : Raven.scriptManager.scripts.values()) {
                                if (!module2.getName().equals(moduleName.substring(3))) continue;
                                module = module2;
                            }
                        }
                        if (module == null) continue;
                        if (module.canBeEnabled()) {
                            if (moduleInformation.has("enabled")) {
                                boolean enabled = moduleInformation.get("enabled").getAsBoolean();
                                if (enabled) {
                                    module.enable();
                                } else {
                                    module.disable();
                                }
                            }
                            if (moduleInformation.has("hidden")) {
                                boolean hidden = moduleInformation.get("hidden").getAsBoolean();
                                module.setHidden(hidden);
                            }
                            if (moduleInformation.has("keybind")) {
                                int keybind = moduleInformation.get("keybind").getAsInt();
                                module.setBind(keybind);
                            }
                        }
                        if (module.getName().equals("HUD")) {
                            if (moduleInformation.has("posX")) {
                                int hudX;
                                HUD.posX = hudX = moduleInformation.get("posX").getAsInt();
                            }
                            if (moduleInformation.has("posY")) {
                                int hudY;
                                HUD.posY = hudY = moduleInformation.get("posY").getAsInt();
                            }
                        } else if (module.getName().equals("TargetInfo")) {
                            if (moduleInformation.has("posX")) {
                                int posX;
                                ModuleManager.targetInfo.posX = posX = moduleInformation.get("posX").getAsInt();
                            }
                            if (moduleInformation.has("posY")) {
                                int posY;
                                ModuleManager.targetInfo.posY = posY = moduleInformation.get("posY").getAsInt();
                            }
                        } else if (module.getName().equals("Sprint")) {
                            if (moduleInformation.has("posX")) {
                                float posX;
                                ModuleManager.sprint.posX = posX = moduleInformation.get("posX").getAsFloat();
                            }
                            if (moduleInformation.has("posY")) {
                                float posY;
                                ModuleManager.sprint.posY = posY = moduleInformation.get("posY").getAsFloat();
                            }
                            if (moduleInformation.has("text")) {
                                String text;
                                ModuleManager.sprint.text = text = moduleInformation.get("text").getAsString();
                            }
                        } else if (currentProfileGuiSave && module.getName().equals("Gui")) {
                            block22: for (Map.Entry entry : moduleInformation.entrySet()) {
                                String settingName = (String)entry.getKey();
                                if (!Module.categoriesString.contains(settingName)) continue;
                                String element = ((JsonElement)entry.getValue()).getAsString();
                                String[] statesStr = element.split(",");
                                float posX = Float.parseFloat(statesStr[0]);
                                float posY = Float.parseFloat(statesStr[1]);
                                for (CategoryComponent c : ClickGui.categories) {
                                    boolean opened;
                                    if (!c.category.name().equals(settingName)) continue;
                                    c.setX(posX, true);
                                    c.setY(posY, true);
                                    if (statesStr.length <= 2) continue block22;
                                    c.opened = opened = Boolean.parseBoolean(statesStr[2]);
                                    continue block22;
                                }
                            }
                        }
                        for (Setting setting : module.getSettings()) {
                            setting.loadProfile(moduleInformation);
                        }
                        Raven.currentProfile = this.getProfile(name);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new PostProfileLoadEvent(Raven.currentProfile.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileReader == null) continue;
                    if (throwable != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileReader.close();
                }
            }
            catch (Exception e) {
                this.failedMessage("load", name);
                e.printStackTrace();
            }
        }
    }

    public void deleteProfile(String name) {
        Iterator<Profile> iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile = iterator.next();
            if (!profile.getName().equals(name)) continue;
            iterator.remove();
        }
        if (this.directory.exists()) {
            File[] files;
            for (File file : files = this.directory.listFiles()) {
                if (!file.getName().equals(name + ".json")) continue;
                file.delete();
            }
        }
    }

    public void loadProfiles() {
        this.profiles.clear();
        if (this.directory.exists()) {
            File[] files = this.directory.listFiles();
            for (File file : files) {
                try (FileReader fileReader = new FileReader(file);){
                    JsonParser jsonParser = new JsonParser();
                    JsonObject profileJson = jsonParser.parse((Reader)fileReader).getAsJsonObject();
                    String profileName = file.getName().replace(".json", "");
                    if (profileJson == null) {
                        this.failedMessage("load", profileName);
                        return;
                    }
                    int keybind = 0;
                    if (profileJson.has("keybind")) {
                        keybind = profileJson.get("keybind").getAsInt();
                    }
                    Profile profile = new Profile(profileName, keybind);
                    this.profiles.add(profile);
                }
                catch (Exception e) {
                    Utils.sendMessage("&cFailed to load profiles.");
                    e.printStackTrace();
                }
            }
            for (CategoryComponent categoryComponent : ClickGui.categories) {
                if (categoryComponent.category != Module.category.profiles) continue;
                categoryComponent.reloadModules(true);
            }
            Utils.sendMessage("&b" + Raven.profileManager.getProfileFiles().size() + " &7profiles loaded.");
        }
    }

    public List<File> getProfileFiles() {
        ArrayList<File> profileFiles = new ArrayList<File>();
        if (this.directory.exists()) {
            File[] files;
            for (File file : files = this.directory.listFiles()) {
                if (!file.getName().endsWith(".json")) continue;
                profileFiles.add(file);
            }
        }
        return profileFiles;
    }

    public Profile getProfile(String name) {
        for (Profile profile : this.profiles) {
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return null;
    }

    public void failedMessage(String reason, String name) {
        Utils.sendMessage("&cFailed to " + reason + ": &b" + name);
    }
}

