/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.utility.command.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import keystrokesmod.Raven;
import keystrokesmod.utility.Utils;
import keystrokesmod.utility.command.Command;
import keystrokesmod.utility.profile.Profile;

public class Profiles
extends Command {
    public Profiles() {
        super("profiles", new String[]{"profile", "p"});
    }

    @Override
    public void onExecute(String[] args) {
        String subCommand;
        if (args.length < 2) {
            List<Profile> profiles = Raven.profileManager.profiles;
            if (profiles.isEmpty()) {
                this.chatWithPrefix("&7No profiles found");
                return;
            }
            this.chatWithPrefix("&b" + profiles.size() + " &7profile" + (profiles.size() == 1 ? "" : "s") + " loaded.");
            for (Profile profile : profiles) {
                this.chatWithPrefix(" &7" + profile.getName() + (profile == Raven.currentProfile ? " &7(&bcurrent&7)" : ""));
            }
            return;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "save": 
            case "s": {
                if (args.length < 3) {
                    if (Raven.currentProfile != null) {
                        Utils.sendMessage("&7Saved profile: &b" + Raven.currentProfile);
                        Raven.profileManager.saveProfile(Raven.currentProfile);
                    } else {
                        this.syntaxError();
                    }
                    return;
                }
                String saveName = args[2];
                Profile newProfile = new Profile(saveName, 0);
                Raven.profileManager.saveProfile(newProfile);
                this.chatWithPrefix("&7Saved profile: &b" + saveName);
                Raven.profileManager.loadProfiles();
                break;
            }
            case "load": 
            case "l": {
                if (args.length < 3) {
                    this.syntaxError();
                    return;
                }
                String loadName = args[2];
                if (Raven.profileManager.getProfile(loadName) == null) {
                    this.chatWithPrefix("&b" + loadName + " &7does not exist");
                    return;
                }
                Raven.profileManager.loadProfile(loadName);
                this.chatWithPrefix("&7Enabled profile: &b" + loadName);
                break;
            }
            case "delete": 
            case "remove": 
            case "r": {
                if (args.length < 3) {
                    this.syntaxError();
                    return;
                }
                String deleteName = args[2];
                if (Raven.profileManager.getProfile(deleteName) == null) {
                    this.chatWithPrefix("&cProfile &b" + deleteName + " &7does not exist");
                    return;
                }
                Raven.profileManager.deleteProfile(deleteName);
                this.chatWithPrefix("&7Removed profile: &b" + deleteName);
                Raven.profileManager.loadProfiles();
                break;
            }
            case "rename": {
                if (args.length < 4) {
                    this.syntaxError();
                    return;
                }
                String oldName = args[2];
                String newName = args[3];
                Profile oldProfile = Raven.profileManager.getProfile(oldName);
                if (oldProfile == null) {
                    this.chatWithPrefix("&b" + oldName + " &7does not exist");
                    return;
                }
                if (Raven.profileManager.getProfile(newName) != null) {
                    this.chatWithPrefix("&b" + newName + " &7already exists");
                    return;
                }
                Profile renamedProfile = new Profile(newName, oldProfile.getBind());
                Raven.profileManager.saveProfile(renamedProfile);
                Raven.profileManager.deleteProfile(oldName);
                this.chatWithPrefix("&b" + oldName + " &7renamed to &b" + newName);
                Raven.profileManager.loadProfiles();
                Raven.profileManager.loadProfile(newName);
                break;
            }
            default: {
                this.syntaxError();
            }
        }
    }

    @Override
    public List<String> tabComplete(String[] args) {
        if (args.length == 2) {
            return this.filterStartingWith(args[1], Arrays.asList("save", "s", "load", "l", "delete", "remove", "r", "rename"));
        }
        if (args.length == 3 && !args[1].equalsIgnoreCase("save") && !args[1].equalsIgnoreCase("s")) {
            ArrayList<String> profileNames = new ArrayList<String>();
            for (Profile profile : Raven.profileManager.profiles) {
                profileNames.add(profile.getName());
            }
            return this.filterStartingWith(args[2], profileNames);
        }
        return new ArrayList<String>();
    }

    private List<String> filterStartingWith(String prefix, List<String> options) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String option : options) {
            if (!option.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            filtered.add(option);
        }
        return filtered;
    }
}

