/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.utility.command.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import keystrokesmod.Raven;
import keystrokesmod.module.Module;
import keystrokesmod.module.ModuleManager;
import keystrokesmod.utility.command.Command;
import keystrokesmod.utility.profile.Profile;
import org.lwjgl.input.Keyboard;

public class Binds
extends Command {
    public Binds() {
        super("binds");
    }

    @Override
    public void onExecute(String[] args) {
        if (args.length <= 1) {
            Map<String, List<String>> binds = this.getBindsModulesMap(0);
            int size = this.getTotalModules(binds);
            this.chatWithPrefix("&b" + size + " &7module" + (size == 1 ? "" : "s") + " have keybinds.");
            for (Map.Entry<String, List<String>> entry : binds.entrySet()) {
                String key = entry.getKey();
                List<String> moduleNames = entry.getValue();
                for (String moduleName : moduleNames) {
                    this.chatWithPrefix(" &b" + key + " &7" + moduleName);
                }
            }
        } else if (args.length == 2) {
            int keycode = Keyboard.getKeyIndex((String)args[1].toUpperCase());
            if (keycode == 0) {
                this.chatWithPrefix("&7Invalid key.");
                return;
            }
            Map<String, List<String>> binds = this.getBindsModulesMap(keycode);
            int size = this.getTotalModules(binds);
            this.chatWithPrefix("&b" + size + " &7module" + (size == 1 ? "" : "s") + " has keybind &b" + args[1].toUpperCase() + "&7.");
            for (Map.Entry<String, List<String>> entry : binds.entrySet()) {
                String key = entry.getKey();
                List<String> moduleNames = entry.getValue();
                for (String moduleName : moduleNames) {
                    this.chatWithPrefix(" &b" + key + " &7" + moduleName);
                }
            }
        } else {
            this.syntaxError();
        }
    }

    private Map<String, List<String>> getBindsModulesMap(int keycode) {
        HashMap<String, List<String>> binds = new HashMap<String, List<String>>();
        for (Module module : ModuleManager.modules) {
            this.addModuleIfMatches(binds, module, keycode);
        }
        for (Profile profile : Raven.profileManager.profiles) {
            Module module = profile.getModule();
            this.addModuleIfMatches(binds, module, keycode);
        }
        for (Module scriptModule : Raven.scriptManager.scripts.values()) {
            this.addModuleIfMatches(binds, scriptModule, keycode);
        }
        return binds;
    }

    private void addModuleIfMatches(Map<String, List<String>> bindsMap, Module module, int keycode) {
        if (module.getKeycode() == 0) {
            return;
        }
        if (keycode != 0 && module.getKeycode() != keycode) {
            return;
        }
        String keyName = module.getKeycode() >= 1000 ? "M" + (module.getKeycode() - 1000) : Keyboard.getKeyName((int)module.getKeycode());
        List<String> moduleNames = bindsMap.get(keyName);
        if (moduleNames == null) {
            moduleNames = new ArrayList<String>();
            bindsMap.put(keyName, moduleNames);
        }
        moduleNames.add(module.getName());
    }

    private int getTotalModules(Map<String, List<String>> binds) {
        int total = 0;
        for (List<String> modules2 : binds.values()) {
            total += modules2.size();
        }
        return total;
    }
}

