/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.utility;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import keystrokesmod.utility.NetworkUtils;

public class ProfileUtils {
    public static String getMojangProfile(String n) {
        String result = "";
        String response = NetworkUtils.getTextFromURL("https://api.mojang.com/users/profiles/minecraft/" + n, false, false);
        if (!response.isEmpty()) {
            try {
                result = response.split("d\":\"")[1].split("\"")[0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }

    public static int[] getHypixelStats(String playerName, DM dm) {
        JsonObject d;
        int[] s = new int[]{0, 0, 0};
        String u = ProfileUtils.getMojangProfile(playerName);
        if (u.isEmpty()) {
            s[0] = -1;
            return s;
        }
        String c = NetworkUtils.getTextFromURL("https://api.hypixel.net/player?key=" + NetworkUtils.API_KEY + "&uuid=" + u, false, false);
        if (c.isEmpty()) {
            return null;
        }
        if (c.equals("{\"success\":true,\"player\":null}")) {
            s[0] = -1;
            return s;
        }
        try {
            JsonObject pr = ProfileUtils.parseJson(c).getAsJsonObject("player");
            d = pr.getAsJsonObject("stats").getAsJsonObject("Duels");
        }
        catch (NullPointerException var8) {
            return s;
        }
        switch (dm) {
            case OVERALL: {
                s[0] = ProfileUtils.getValueAsInt(d, "wins");
                s[1] = ProfileUtils.getValueAsInt(d, "losses");
                s[2] = ProfileUtils.getValueAsInt(d, "current_winstreak");
                break;
            }
            case BRIDGE: {
                s[0] = ProfileUtils.getValueAsInt(d, "bridge_duel_wins");
                s[1] = ProfileUtils.getValueAsInt(d, "bridge_duel_losses");
                s[2] = ProfileUtils.getValueAsInt(d, "current_winstreak_mode_bridge_duel");
                break;
            }
            case UHC: {
                s[0] = ProfileUtils.getValueAsInt(d, "uhc_duel_wins");
                s[1] = ProfileUtils.getValueAsInt(d, "uhc_duel_losses");
                s[2] = ProfileUtils.getValueAsInt(d, "current_winstreak_mode_uhc_duel");
                break;
            }
            case SKYWARS: {
                s[0] = ProfileUtils.getValueAsInt(d, "sw_duel_wins");
                s[1] = ProfileUtils.getValueAsInt(d, "sw_duel_losses");
                s[2] = ProfileUtils.getValueAsInt(d, "current_winstreak_mode_sw_duel");
                break;
            }
            case CLASSIC: {
                s[0] = ProfileUtils.getValueAsInt(d, "classic_duel_wins");
                s[1] = ProfileUtils.getValueAsInt(d, "classic_duel_losses");
                s[2] = ProfileUtils.getValueAsInt(d, "current_winstreak_mode_classic_duel");
                break;
            }
            case SUMO: {
                s[0] = ProfileUtils.getValueAsInt(d, "sumo_duel_wins");
                s[1] = ProfileUtils.getValueAsInt(d, "sumo_duel_losses");
                s[2] = ProfileUtils.getValueAsInt(d, "current_winstreak_mode_sumo_duel");
                break;
            }
            case OP: {
                s[0] = ProfileUtils.getValueAsInt(d, "op_duel_wins");
                s[1] = ProfileUtils.getValueAsInt(d, "op_duel_losses");
                s[2] = ProfileUtils.getValueAsInt(d, "current_winstreak_mode_op_duel");
            }
        }
        return s;
    }

    public static JsonObject parseJson(String json) {
        return new JsonParser().parse(json).getAsJsonObject();
    }

    private static int getValueAsInt(JsonObject jsonObject, String key) {
        try {
            return jsonObject.get(key).getAsInt();
        }
        catch (NullPointerException var3) {
            return 0;
        }
    }

    public static enum DM {
        OVERALL,
        BRIDGE,
        UHC,
        SKYWARS,
        CLASSIC,
        SUMO,
        OP;

    }
}

