/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.utility;

import keystrokesmod.utility.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class BlockUtils {
    public static final Minecraft mc = Minecraft.func_71410_x();

    public static boolean isSamePos(BlockPos blockPos, BlockPos blockPos2) {
        return blockPos == blockPos2 || blockPos.func_177958_n() == blockPos2.func_177958_n() && blockPos.func_177956_o() == blockPos2.func_177956_o() && blockPos.func_177952_p() == blockPos2.func_177952_p();
    }

    public static boolean notFull(Block block) {
        return block instanceof BlockFenceGate || block instanceof BlockLadder || block instanceof BlockFlowerPot || block instanceof BlockBasePressurePlate || BlockUtils.isFluid(block) || block instanceof BlockFence || block instanceof BlockAnvil || block instanceof BlockEnchantmentTable || block instanceof BlockChest;
    }

    public static boolean isNormalBlock(Block block) {
        return block == Blocks.field_150359_w || block.func_149730_j() && block != Blocks.field_150351_n && block != Blocks.field_150354_m && block != Blocks.field_150425_aM && block != Blocks.field_150335_W && block != Blocks.field_150462_ai && block != Blocks.field_150460_al && block != Blocks.field_150367_z && block != Blocks.field_150409_cd && block != Blocks.field_150323_B && block != Blocks.field_150483_bI;
    }

    public static AxisAlignedBB getAABB(BlockPos blockPos) {
        return BlockUtils.getBlockState(blockPos).func_177230_c().func_180640_a((World)BlockUtils.mc.field_71441_e, blockPos, BlockUtils.getBlockState(blockPos));
    }

    public static BlockPos pos(double x, double y, double z) {
        return new BlockPos(x, y, z);
    }

    public static boolean isBlockPosEqual(BlockPos pos1, BlockPos pos2) {
        return pos1 == pos2 || pos1.func_177958_n() == pos2.func_177958_n() && pos1.func_177956_o() == pos2.func_177956_o() && pos1.func_177952_p() == pos2.func_177952_p();
    }

    public static BlockPos offsetPos(MovingObjectPosition mop) {
        return mop.func_178782_a().func_177972_a(mop.field_178784_b);
    }

    public static boolean isFluid(Block block) {
        return block.func_149688_o() == Material.field_151587_i || block.func_149688_o() == Material.field_151586_h;
    }

    public static boolean isInteractable(Block block) {
        return block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockFurnace || block instanceof BlockTrapDoor || block instanceof BlockDoor || block instanceof BlockContainer || block instanceof BlockJukebox || block instanceof BlockFenceGate || block instanceof BlockEnchantmentTable || block instanceof BlockBrewingStand || block instanceof BlockBed || block instanceof BlockDropper || block instanceof BlockDispenser || block instanceof BlockHopper || block instanceof BlockAnvil || block instanceof BlockNote || block instanceof BlockWorkbench;
    }

    public static boolean isChest(Block block) {
        return block instanceof BlockChest || block instanceof BlockEnderChest;
    }

    public static boolean isInteractable(MovingObjectPosition mv, boolean checkSneaking) {
        if (mv == null || mv.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || mv.func_178782_a() == null) {
            return false;
        }
        if (!checkSneaking || !BlockUtils.mc.field_71439_g.func_70093_af() || BlockUtils.mc.field_71439_g.func_70694_bm() == null) {
            return BlockUtils.isInteractable(BlockUtils.getBlock(mv.func_178782_a()));
        }
        return false;
    }

    public static boolean isChest(MovingObjectPosition mv) {
        if (mv == null || mv.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || mv.func_178782_a() == null) {
            return false;
        }
        return BlockUtils.isChest(BlockUtils.getBlock(mv.func_178782_a()));
    }

    public static float getBlockHardness(Block block, ItemStack itemStack, boolean ignoreSlow, boolean ignoreGround) {
        float getBlockHardness = block.func_176195_g((World)BlockUtils.mc.field_71441_e, null);
        if (getBlockHardness < 0.0f) {
            return 0.0f;
        }
        return block.func_149688_o().func_76229_l() || itemStack != null && itemStack.func_150998_b(block) ? BlockUtils.getToolDigEfficiency(itemStack, block, ignoreSlow, ignoreGround) / getBlockHardness / 30.0f : BlockUtils.getToolDigEfficiency(itemStack, block, ignoreSlow, ignoreGround) / getBlockHardness / 100.0f;
    }

    public static float getToolDigEfficiency(ItemStack itemStack, Block block, boolean ignoreSlow, boolean ignoreGround) {
        int getEnchantmentLevel;
        float n;
        float f = n = itemStack == null ? 1.0f : itemStack.func_77973_b().func_150893_a(itemStack, block);
        if (n > 1.0f && (getEnchantmentLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)itemStack)) > 0 && itemStack != null) {
            n += (float)(getEnchantmentLevel * getEnchantmentLevel + 1);
        }
        if (BlockUtils.mc.field_71439_g.func_70644_a(Potion.field_76422_e)) {
            n *= 1.0f + (float)(BlockUtils.mc.field_71439_g.func_70660_b(Potion.field_76422_e).func_76458_c() + 1) * 0.2f;
        }
        if (!ignoreSlow) {
            if (BlockUtils.mc.field_71439_g.func_70644_a(Potion.field_76419_f)) {
                float n2;
                switch (BlockUtils.mc.field_71439_g.func_70660_b(Potion.field_76419_f).func_76458_c()) {
                    case 0: {
                        n2 = 0.3f;
                        break;
                    }
                    case 1: {
                        n2 = 0.09f;
                        break;
                    }
                    case 2: {
                        n2 = 0.0027f;
                        break;
                    }
                    default: {
                        n2 = 8.1E-4f;
                    }
                }
                n *= n2;
            }
            if (BlockUtils.mc.field_71439_g.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)BlockUtils.mc.field_71439_g)) {
                n /= 5.0f;
            }
            if (!BlockUtils.mc.field_71439_g.field_70122_E && !ignoreGround) {
                n /= 5.0f;
            }
        }
        return n;
    }

    public static Block getBlock(BlockPos blockPos) {
        return BlockUtils.getBlockState(blockPos).func_177230_c();
    }

    public static Block getBlock(double x, double y, double z) {
        return BlockUtils.getBlockState(new BlockPos(x, y, z)).func_177230_c();
    }

    public static IBlockState getBlockState(BlockPos blockPos) {
        return BlockUtils.mc.field_71441_e.func_180495_p(blockPos);
    }

    public static boolean check(BlockPos blockPos, Block block) {
        return BlockUtils.getBlock(blockPos) == block;
    }

    public static boolean replaceable(BlockPos blockPos) {
        if (!Utils.nullCheck()) {
            return true;
        }
        return BlockUtils.getBlock(blockPos).func_176200_f((World)BlockUtils.mc.field_71441_e, blockPos);
    }

    public static boolean canSeeVecBlock(BlockPos pos, Vec3 vecPlayer, Vec3 vecBlockPoint) {
        BlockPos mopPos;
        MovingObjectPosition mop = BlockUtils.mc.field_71441_e.func_147447_a(vecPlayer, vecBlockPoint, false, false, false);
        if (mop == null) {
            return true;
        }
        return mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (mopPos = mop.func_178782_a()).func_177958_n() == pos.func_177958_n() && mopPos.func_177956_o() == pos.func_177956_o() && mopPos.func_177952_p() == pos.func_177952_p();
    }

    public static boolean canBlockBeSeen(BlockPos pos) {
        Vec3 vecPlayer = new Vec3(BlockUtils.mc.field_71439_g.field_70165_t, BlockUtils.mc.field_71439_g.field_70163_u + (double)BlockUtils.mc.field_71439_g.func_70047_e(), BlockUtils.mc.field_71439_g.field_70161_v);
        for (double offsetY = 0.0; offsetY <= 0.5; offsetY += 0.5) {
            double y = (double)pos.func_177956_o() + offsetY;
            Vec3 vecBlockPoint = new Vec3((double)(pos.func_177958_n() + 1), y, (double)pos.func_177952_p() + 0.5);
            if (BlockUtils.canSeeVecBlock(pos, vecPlayer, vecBlockPoint)) {
                return true;
            }
            vecBlockPoint = new Vec3((double)pos.func_177958_n(), y, (double)pos.func_177952_p() + 0.5);
            if (BlockUtils.canSeeVecBlock(pos, vecPlayer, vecBlockPoint)) {
                return true;
            }
            vecBlockPoint = new Vec3((double)pos.func_177958_n() + 0.5, y, (double)(pos.func_177952_p() + 1));
            if (BlockUtils.canSeeVecBlock(pos, vecPlayer, vecBlockPoint)) {
                return true;
            }
            vecBlockPoint = new Vec3((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p());
            if (!BlockUtils.canSeeVecBlock(pos, vecPlayer, vecBlockPoint)) continue;
            return true;
        }
        return false;
    }

    public static EnumDyeColor getWoolColor(IBlockState state) {
        return (EnumDyeColor)state.func_177228_b().get((Object)BlockColored.field_176581_a);
    }
}

