/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.script.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Json {
    private final JsonElement element;
    private final Type type;

    private Json(JsonElement element) {
        JsonPrimitive prim;
        this.element = element;
        this.type = element.isJsonObject() ? Type.OBJECT : (element.isJsonArray() ? Type.ARRAY : (element.isJsonPrimitive() ? ((prim = element.getAsJsonPrimitive()).isBoolean() ? Type.BOOLEAN : (prim.isNumber() ? Type.NUMBER : Type.STRING)) : (element.isJsonNull() ? Type.NULL : Type.NULL)));
    }

    public static Json parse(String jsonString) {
        return new Json(new JsonParser().parse(jsonString));
    }

    public static Json object() {
        return new Json((JsonElement)new JsonObject());
    }

    public static Json array() {
        return new Json((JsonElement)new JsonArray());
    }

    public static Json string(String value) {
        return new Json((JsonElement)new JsonPrimitive(value));
    }

    public static Json number(Number value) {
        return new Json((JsonElement)new JsonPrimitive(value));
    }

    public static Json booleanValue(boolean value) {
        return new Json((JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
    }

    public static Json nullValue() {
        return new Json((JsonElement)JsonNull.INSTANCE);
    }

    public Type type() {
        return this.type;
    }

    private void ensureObject() {
        if (this.type != Type.OBJECT) {
            throw new IllegalStateException("Not a JSON object: " + (Object)((Object)this.type));
        }
    }

    public Json add(String key, Json value) {
        this.ensureObject();
        this.element.getAsJsonObject().add(key, value.element);
        return this;
    }

    public Json add(String key, String val) {
        return this.add(key, Json.string(val));
    }

    public Json add(String key, Number val) {
        return this.add(key, Json.number(val));
    }

    public Json add(String key, boolean val) {
        return this.add(key, Json.booleanValue(val));
    }

    public Json get(String key) {
        this.ensureObject();
        JsonElement child = this.element.getAsJsonObject().get(key);
        return child == null ? Json.nullValue() : new Json(child);
    }

    public boolean has(String key) {
        this.ensureObject();
        return this.element.getAsJsonObject().has(key);
    }

    private void ensureArray() {
        if (this.type != Type.ARRAY) {
            throw new IllegalStateException("Not a JSON array: " + (Object)((Object)this.type));
        }
    }

    public Json add(Json value) {
        this.ensureArray();
        this.element.getAsJsonArray().add(value.element);
        return this;
    }

    public Json add(String val) {
        return this.add(Json.string(val));
    }

    public Json add(Number val) {
        return this.add(Json.number(val));
    }

    public Json add(boolean val) {
        return this.add(Json.booleanValue(val));
    }

    public List<Json> asArray() {
        this.ensureArray();
        ArrayList<Json> list = new ArrayList<Json>();
        for (JsonElement el : this.element.getAsJsonArray()) {
            list.add(new Json(el));
        }
        return list;
    }

    private void ensurePrimitive() {
        if (this.type != Type.STRING && this.type != Type.NUMBER && this.type != Type.BOOLEAN) {
            throw new IllegalStateException("Not a primitive: " + (Object)((Object)this.type));
        }
    }

    public String asString() {
        this.ensurePrimitive();
        return this.element.getAsString();
    }

    public int asInt() {
        this.ensurePrimitive();
        return this.element.getAsInt();
    }

    public double asDouble() {
        this.ensurePrimitive();
        return this.element.getAsDouble();
    }

    public long asLong() {
        this.ensurePrimitive();
        return this.element.getAsLong();
    }

    public float asFloat() {
        this.ensurePrimitive();
        return this.element.getAsFloat();
    }

    public boolean asBoolean() {
        this.ensurePrimitive();
        return this.element.getAsBoolean();
    }

    public LinkedHashSet<String> keys() {
        this.ensureObject();
        LinkedHashSet<String> out = new LinkedHashSet<String>();
        for (Map.Entry e : this.element.getAsJsonObject().entrySet()) {
            out.add((String)e.getKey());
        }
        return out;
    }

    public String toString() {
        return this.element.toString();
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        STRING,
        NUMBER,
        BOOLEAN,
        NULL;

    }
}

