/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.script;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import keystrokesmod.Raven;

public class SecureClassLoader
extends URLClassLoader {
    private static final List<String> WHITELISTED_PACKAGES = Arrays.asList("sun.reflect", "keystrokesmod", "java.lang", "java.util", "java.awt");

    public SecureClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.isClassSafe(name)) {
            throw new ClassNotFoundException("Unsafe class detected: " + name);
        }
        return super.loadClass(name, resolve);
    }

    private boolean isClassSafe(String name) {
        boolean hasAllowedSuffix = name.endsWith("Exception") || name.endsWith("Throwable");
        boolean isAllowedImport = Raven.scriptManager.imports.stream().anyMatch(prefix -> name.toLowerCase().startsWith((String)prefix));
        boolean isScriptClass = name.startsWith("sc_") && !name.contains(".");
        boolean isWhitelistedPackage = WHITELISTED_PACKAGES.stream().anyMatch(name::startsWith);
        return hasAllowedSuffix || isAllowedImport || isScriptClass || isWhitelistedPackage;
    }
}

