/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.module.impl.render;

import java.awt.Color;
import java.io.IOException;
import keystrokesmod.module.Module;
import keystrokesmod.module.impl.combat.KillAura;
import keystrokesmod.module.setting.impl.ButtonSetting;
import keystrokesmod.module.setting.impl.DescriptionSetting;
import keystrokesmod.module.setting.impl.SliderSetting;
import keystrokesmod.utility.RenderUtils;
import keystrokesmod.utility.Theme;
import keystrokesmod.utility.Timer;
import keystrokesmod.utility.Utils;
import keystrokesmod.utility.shader.BlurUtils;
import keystrokesmod.utility.shader.RoundedUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class TargetInfo
extends Module {
    private SliderSetting mode;
    private SliderSetting theme;
    private ButtonSetting renderHUD;
    private ButtonSetting renderESP;
    private SliderSetting espMode;
    private ButtonSetting showStatus;
    private ButtonSetting healthColor;
    private Timer fadeTimer;
    private Timer healthBarTimer = null;
    private EntityLivingBase target;
    private long lastAliveMS;
    private double lastHealth;
    private float lastHealthBar;
    public int posX = 70;
    public int posY = 30;
    private String[] modes = new String[]{"Modern", "Legacy"};
    private String[] espModes = new String[]{"Theme", "Team", "Hurttime"};
    private SliderSetting min;

    public TargetInfo() {
        super("TargetInfo", Module.category.render);
        this.registerSetting(new DescriptionSetting("Only works with KillAura."));
        this.renderHUD = new ButtonSetting("Render HUD", true);
        this.registerSetting(this.renderHUD);
        this.mode = new SliderSetting("Mode", 1, this.modes);
        this.registerSetting(this.mode);
        this.theme = new SliderSetting("Theme", 0, Theme.themes);
        this.registerSetting(this.theme);
        this.registerSetting(new ButtonSetting("Edit position", () -> mc.func_147108_a((GuiScreen)new EditScreen())));
        this.renderESP = new ButtonSetting("Render ESP", true);
        this.registerSetting(this.renderESP);
        this.espMode = new SliderSetting("ESP mode", 1, this.espModes);
        this.registerSetting(this.espMode);
        this.min = new SliderSetting("Minimum hurttime", 1.0, 1.0, 9.0, 1.0);
        this.registerSetting(this.min);
        this.showStatus = new ButtonSetting("Show win or loss", true);
        this.registerSetting(this.showStatus);
        this.healthColor = new ButtonSetting("Traditional health color", false);
        this.registerSetting(this.healthColor);
    }

    @Override
    public void guiUpdate() {
        this.min.setVisible(this.espMode.getInput() == 2.0, this);
    }

    @Override
    public void onDisable() {
        this.reset();
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        if (!Utils.nullCheck()) {
            this.reset();
            return;
        }
        if (ev.phase == TickEvent.Phase.END) {
            if (TargetInfo.mc.field_71462_r != null) {
                this.reset();
                return;
            }
            if (KillAura.attackingEntity != null) {
                this.target = KillAura.attackingEntity;
                this.lastAliveMS = System.currentTimeMillis();
                this.fadeTimer = null;
            } else if (this.target != null) {
                if (System.currentTimeMillis() - this.lastAliveMS >= 400L && this.fadeTimer == null) {
                    this.fadeTimer = new Timer(400.0f);
                    this.fadeTimer.start();
                }
            } else {
                return;
            }
            String playerInfo = this.target.func_145748_c_().func_150254_d();
            double health = this.target.func_110143_aJ() / this.target.func_110138_aP();
            if (this.target.field_70128_L) {
                health = 0.0;
            }
            if (health != this.lastHealth) {
                this.healthBarTimer = new Timer(this.mode.getInput() == 0.0 ? 500.0f : 350.0f);
                this.healthBarTimer.start();
            }
            this.lastHealth = health;
            playerInfo = playerInfo + " " + Utils.getHealthStr(this.target, true);
            if (this.renderHUD.isToggled()) {
                this.drawTargetHUD(this.fadeTimer, playerInfo, health);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderWorld(RenderWorldLastEvent renderWorldLastEvent) {
        if (!this.renderESP.isToggled() || !Utils.nullCheck()) {
            return;
        }
        if (KillAura.target != null) {
            RenderUtils.renderEntity((Entity)KillAura.target, 2, 0.0, 0.0, this.returnColor(), false);
        }
    }

    private int returnColor() {
        if (this.espMode.getInput() == 0.0) {
            return Theme.getGradient((int)this.theme.getInput(), 0.0);
        }
        if (this.espMode.getInput() == 1.0) {
            return Utils.mergeAlpha(Utils.getColorFromEntity((Entity)KillAura.target), 255);
        }
        if (this.espMode.getInput() == 2.0) {
            int dc = new Color(251, 86, 86, 255).getRGB();
            int nc = new Color(107, 255, 103, 255).getRGB();
            return (double)Utils.getHurttime((Entity)KillAura.target) >= this.min.getInput() ? dc : nc;
        }
        return 0;
    }

    private void drawTargetHUD(Timer fadeTimer, String string, double health) {
        int alpha;
        if (this.showStatus.isToggled()) {
            string = string + " " + (health <= (double)(Utils.getTotalHealth((EntityLivingBase)TargetInfo.mc.field_71439_g) / TargetInfo.mc.field_71439_g.func_110138_aP()) ? "\u00a7aW" : "\u00a7cL");
        }
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int padding = 8;
        int targetStrWithPadding = TargetInfo.mc.field_71466_p.func_78256_a(string) + 8;
        int x = scaledResolution.func_78326_a() / 2 - targetStrWithPadding / 2 + this.posX;
        int y = scaledResolution.func_78328_b() / 2 + 15 + this.posY;
        int n6 = x - 8;
        int n7 = y - 8;
        int n8 = x + targetStrWithPadding;
        int n9 = y + (TargetInfo.mc.field_71466_p.field_78288_b + 5) - 6 + 8;
        int n = alpha = fadeTimer == null ? 255 : 255 - fadeTimer.getValueInt(0, 255, 1);
        if (alpha > 0) {
            int maxAlphaOutline = alpha > 110 ? 110 : alpha;
            int maxAlphaBackground = alpha > 210 ? 210 : alpha;
            int[] gradientColors = Theme.getGradients((int)this.theme.getInput());
            switch ((int)this.mode.getInput()) {
                case 0: {
                    float bloomRadius = fadeTimer == null ? 2.0f : 2.0f * (float)alpha / 255.0f;
                    float blurRadius = fadeTimer == null ? 3.0f : 3.0f * (float)alpha / 255.0f;
                    BlurUtils.prepareBloom();
                    RoundedUtils.drawRound((float)n6, (float)n7, Math.abs((float)n6 - (float)n8), Math.abs((float)n7 - (float)(n9 + 13)), 8.0f, true, new Color(0, 0, 0, maxAlphaBackground));
                    BlurUtils.bloomEnd(3, bloomRadius);
                    BlurUtils.prepareBlur();
                    RoundedUtils.drawRound((float)n6, (float)n7, Math.abs((float)n6 - (float)n8), Math.abs((float)n7 - (float)(n9 + 13)), 8.0f, true, new Color(Utils.mergeAlpha(Color.black.getRGB(), maxAlphaOutline)));
                    BlurUtils.blurEnd(2, blurRadius);
                    break;
                }
                case 1: {
                    RenderUtils.drawRoundedGradientOutlinedRectangle(n6, n7, n8, n9 + 13, 10.0f, Utils.mergeAlpha(Color.black.getRGB(), maxAlphaOutline), Utils.mergeAlpha(gradientColors[0], alpha), Utils.mergeAlpha(gradientColors[1], alpha));
                }
            }
            int n13 = n6 + 6;
            int n14 = n8 - 6;
            int n15 = n9;
            RenderUtils.drawRoundedRectangle(n13, n15, n14, n15 + 5, 4.0f, Utils.mergeAlpha(Color.black.getRGB(), maxAlphaOutline));
            int mergedGradientLeft = Utils.mergeAlpha(gradientColors[0], maxAlphaBackground);
            int mergedGradientRight = Utils.mergeAlpha(gradientColors[1], maxAlphaBackground);
            float healthBar = (int)((double)n14 + (double)(n13 - n14) * (1.0 - health));
            boolean smoothBack = false;
            if (healthBar != this.lastHealthBar && this.lastHealthBar - (float)n13 >= 3.0f && this.healthBarTimer != null) {
                int type = this.mode.getInput() == 0.0 ? 4 : 1;
                float diff = this.lastHealthBar - healthBar;
                if (diff > 0.0f) {
                    this.lastHealthBar -= this.healthBarTimer.getValueFloat(0.0f, diff, type);
                } else {
                    smoothBack = true;
                    this.lastHealthBar = this.healthBarTimer.getValueFloat(this.lastHealthBar, healthBar, type);
                }
            } else {
                this.lastHealthBar = healthBar;
            }
            if (this.healthColor.isToggled()) {
                mergedGradientLeft = mergedGradientRight = Utils.mergeAlpha(Utils.getColorForHealth(health), maxAlphaBackground);
            }
            if (this.lastHealthBar > (float)n14) {
                this.lastHealthBar = n14;
            }
            switch ((int)this.mode.getInput()) {
                case 0: {
                    RenderUtils.drawRoundedRectangle(n13, n15, this.lastHealthBar, n15 + 5, 4.0f, Utils.darkenColor(mergedGradientRight, 25.0));
                    RenderUtils.drawRoundedGradientRect(n13, n15, smoothBack ? this.lastHealthBar : healthBar, n15 + 5, 4.0f, mergedGradientLeft, mergedGradientLeft, mergedGradientRight, mergedGradientRight);
                    break;
                }
                case 1: {
                    RenderUtils.drawRoundedGradientRect(n13, n15, this.lastHealthBar, n15 + 5, 4.0f, mergedGradientLeft, mergedGradientLeft, mergedGradientRight, mergedGradientRight);
                }
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            TargetInfo.mc.field_71466_p.func_175065_a(string, (float)x, (float)y, new Color(220, 220, 220, 255).getRGB() & 0xFFFFFF | Utils.clamp(alpha + 15) << 24, true);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        } else {
            this.target = null;
            this.healthBarTimer = null;
        }
    }

    private void reset() {
        this.fadeTimer = null;
        this.target = null;
        this.healthBarTimer = null;
    }

    class EditScreen
    extends GuiScreen {
        GuiButtonExt resetPosition;
        boolean d = false;
        int miX = 0;
        int miY = 0;
        int maX = 0;
        int maY = 0;
        int aX = 70;
        int aY = 30;
        int laX = 0;
        int laY = 0;
        int lmX = 0;
        int lmY = 0;
        int clickMinX = 0;

        EditScreen() {
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.resetPosition = new GuiButtonExt(1, this.field_146294_l - 90, this.field_146295_m - 25, 85, 20, "Reset position");
            this.field_146292_n.add(this.resetPosition);
            this.aX = TargetInfo.this.posX;
            this.aY = TargetInfo.this.posY;
        }

        public void func_73863_a(int mX, int mY, float pt) {
            ScaledResolution res = new ScaledResolution(this.field_146297_k);
            EditScreen.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1308622848);
            int miX = this.aX;
            int miY = this.aY;
            String playerInfo = this.field_146297_k.field_71439_g.func_145748_c_().func_150254_d();
            double health = this.field_146297_k.field_71439_g.func_110143_aJ() / this.field_146297_k.field_71439_g.func_110138_aP();
            if (this.field_146297_k.field_71439_g.field_70128_L) {
                health = 0.0;
            }
            TargetInfo.this.lastHealth = health;
            playerInfo = playerInfo + " " + Utils.getHealthStr((EntityLivingBase)this.field_146297_k.field_71439_g, true);
            TargetInfo.this.drawTargetHUD(null, playerInfo, health);
            if (TargetInfo.this.showStatus.isToggled()) {
                playerInfo = playerInfo + " " + (health <= (double)(Utils.getTotalHealth((EntityLivingBase)this.field_146297_k.field_71439_g) / this.field_146297_k.field_71439_g.func_110138_aP()) ? "\u00a7aW" : "\u00a7cL");
            }
            int stringWidth = this.field_146297_k.field_71466_p.func_78256_a(playerInfo) + 8;
            int maX = res.func_78326_a() / 2 - stringWidth / 2 + miX + this.field_146297_k.field_71466_p.func_78256_a(playerInfo) + 8;
            int maY = res.func_78328_b() / 2 + 15 + miY + (this.field_146297_k.field_71466_p.field_78288_b + 5) - 6 + 8;
            this.miX = miX;
            this.miY = miY;
            this.maX = maX;
            this.maY = maY;
            this.clickMinX = miX;
            TargetInfo.this.posX = miX;
            TargetInfo.this.posY = miY;
            String edit = "Edit the HUD position by dragging.";
            int x = res.func_78326_a() / 2 - this.field_146289_q.func_78256_a(edit) / 2;
            int y = res.func_78328_b() / 2 - 20;
            RenderUtils.drawColoredString(edit, '-', x, y, 2L, 0L, true, this.field_146297_k.field_71466_p);
            try {
                this.func_146269_k();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.func_73863_a(mX, mY, pt);
        }

        protected void func_146273_a(int mX, int mY, int b, long t) {
            super.func_146273_a(mX, mY, b, t);
            if (b == 0) {
                if (this.d) {
                    this.aX = this.laX + (mX - this.lmX);
                    this.aY = this.laY + (mY - this.lmY);
                } else if (mX > this.clickMinX && mX < this.maX && mY > this.miY && mY < this.maY) {
                    this.d = true;
                    this.lmX = mX;
                    this.lmY = mY;
                    this.laX = this.aX;
                    this.laY = this.aY;
                }
            }
        }

        protected void func_146286_b(int mX, int mY, int s) {
            super.func_146286_b(mX, mY, s);
            if (s == 0) {
                this.d = false;
            }
        }

        public void func_146284_a(GuiButton b) {
            if (b == this.resetPosition) {
                TargetInfo.this.posX = 70;
                this.aX = 70;
                TargetInfo.this.posY = 30;
                this.aY = 30;
            }
        }

        public boolean func_73868_f() {
            return false;
        }
    }
}

