/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.module.impl.render;

import java.awt.Color;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import keystrokesmod.mixin.impl.accessor.IAccessorEntityArrow;
import keystrokesmod.mixin.impl.accessor.IAccessorEntityRenderer;
import keystrokesmod.mixin.impl.accessor.IAccessorMinecraft;
import keystrokesmod.module.Module;
import keystrokesmod.module.setting.impl.ButtonSetting;
import keystrokesmod.module.setting.impl.GroupSetting;
import keystrokesmod.module.setting.impl.SliderSetting;
import keystrokesmod.utility.BlockUtils;
import keystrokesmod.utility.RenderUtils;
import keystrokesmod.utility.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class Indicators
extends Module {
    private GroupSetting items;
    private ButtonSetting renderArrows;
    private ButtonSetting renderPearls;
    private ButtonSetting renderFireballs;
    private ButtonSetting renderEggs;
    private ButtonSetting renderSnowballs;
    private SliderSetting arrow;
    private SliderSetting radius;
    private ButtonSetting itemColors;
    private ButtonSetting renderItem;
    private ButtonSetting renderDistance;
    private ButtonSetting threatsOnly;
    private ButtonSetting renderOnlyOffScreen;
    private HashSet<Entity> threats = new HashSet();
    private Map<String, String> lastHeldItems = new ConcurrentHashMap<String, String>();
    private String[] arrowTypes = new String[]{"Caret", "Greater than", "Triangle"};

    public Indicators() {
        super("Indicators", Module.category.render);
        this.items = new GroupSetting("Items");
        this.registerSetting(this.items);
        this.renderArrows = new ButtonSetting(this.items, "Render arrows", true);
        this.registerSetting(this.renderArrows);
        this.renderPearls = new ButtonSetting(this.items, "Render ender pearls", true);
        this.registerSetting(this.renderPearls);
        this.renderFireballs = new ButtonSetting(this.items, "Render fireballs", true);
        this.registerSetting(this.renderFireballs);
        this.renderEggs = new ButtonSetting(this.items, "Render eggs", false);
        this.registerSetting(this.renderEggs);
        this.renderSnowballs = new ButtonSetting(this.items, "Render snowballs", false);
        this.registerSetting(this.renderSnowballs);
        this.arrow = new SliderSetting("Arrow", 0, this.arrowTypes);
        this.registerSetting(this.arrow);
        this.radius = new SliderSetting("Circle radius", 50.0, 30.0, 200.0, 5.0);
        this.registerSetting(this.radius);
        this.itemColors = new ButtonSetting("Item colors", true);
        this.registerSetting(this.itemColors);
        this.renderItem = new ButtonSetting("Render item", true);
        this.registerSetting(this.renderItem);
        this.renderDistance = new ButtonSetting("Render distance", true);
        this.registerSetting(this.renderDistance);
        this.threatsOnly = new ButtonSetting("Render only threats", true);
        this.registerSetting(this.threatsOnly);
        this.renderOnlyOffScreen = new ButtonSetting("Render only offscreen", false);
        this.registerSetting(this.renderOnlyOffScreen);
    }

    @Override
    public void onDisable() {
        this.threats.clear();
        this.lastHeldItems.clear();
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Indicators.mc.field_71462_r != null || !Utils.nullCheck()) {
            return;
        }
        try {
            for (Entity en : Indicators.mc.field_71441_e.field_72996_f) {
                if (en == null || en == Indicators.mc.field_71439_g) continue;
                ItemStack itemStack = null;
                if (en instanceof EntityArrow) {
                    if (((IAccessorEntityArrow)en).getInGround()) {
                        this.threats.remove(en);
                        continue;
                    }
                    itemStack = new ItemStack(Items.field_151032_g);
                } else if (en instanceof EntityFireball) {
                    itemStack = new ItemStack(Items.field_151059_bz);
                } else if (en instanceof EntityEnderPearl) {
                    itemStack = new ItemStack(Items.field_151079_bi);
                } else if (en instanceof EntityEgg) {
                    itemStack = new ItemStack(Items.field_151110_aK);
                } else if (en instanceof EntitySnowball) {
                    itemStack = new ItemStack(Items.field_151126_ay);
                }
                if (!this.threats.contains(en)) continue;
                if (!Indicators.mc.field_71441_e.field_72996_f.contains(en) || !this.canRender(en)) {
                    this.threats.remove(en);
                    continue;
                }
                this.renderIndicatorFor(en, itemStack, event.renderTickTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent e) {
        if (!Utils.nullCheck()) {
            return;
        }
        if (e.entity == Indicators.mc.field_71439_g) {
            this.threats.clear();
        } else if (this.canRender(e.entity) && (Indicators.mc.field_71439_g.func_70068_e(e.entity) > 36.0 || !this.threatsOnly.isToggled())) {
            this.threats.add(e.entity);
        }
    }

    private boolean canRender(Entity entity) {
        if (entity instanceof EntityArrow && !((IAccessorEntityArrow)entity).getInGround() && this.renderArrows.isToggled()) {
            return true;
        }
        if (entity instanceof EntityLargeFireball && this.renderFireballs.isToggled()) {
            return true;
        }
        if (entity instanceof EntityEnderPearl && this.renderPearls.isToggled()) {
            return true;
        }
        if (entity instanceof EntityEgg && this.renderEggs.isToggled()) {
            return true;
        }
        return entity instanceof EntitySnowball && this.renderSnowballs.isToggled();
    }

    private void renderIndicatorFor(Entity en, ItemStack itemStack, float partialTicks) {
        if (!this.canRender(en)) {
            return;
        }
        if (!this.shouldRender(en, itemStack)) {
            return;
        }
        if (this.renderOnlyOffScreen.isToggled() && RenderUtils.isInViewFrustum(en)) {
            return;
        }
        Color colorForStack = this.getColorForItem(itemStack);
        int color = this.itemColors.isToggled() ? colorForStack.getRGB() : -1;
        double x = en.field_70142_S + (en.field_70165_t - en.field_70142_S) * (double)partialTicks - Indicators.mc.func_175598_ae().field_78730_l;
        double y = en.field_70137_T + (en.field_70163_u - en.field_70137_T) * (double)partialTicks - Indicators.mc.func_175598_ae().field_78731_m + (double)(en.field_70131_O / 2.0f);
        double z = en.field_70136_U + (en.field_70161_v - en.field_70136_U) * (double)partialTicks - Indicators.mc.func_175598_ae().field_78728_n;
        ((IAccessorEntityRenderer)Indicators.mc.field_71460_t).callSetupCameraTransform(((IAccessorMinecraft)Indicators.mc).getTimer().field_74281_c, 0);
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        Vec3 vec = RenderUtils.convertTo2D(scaledResolution.func_78325_e(), x, y, z);
        if (vec != null) {
            boolean inFrustum;
            Indicators.mc.field_71460_t.func_78478_c();
            ScaledResolution res = new ScaledResolution(mc);
            double dx = vec.field_72450_a - (double)res.func_78326_a() / 2.0;
            double dy = vec.field_72448_b - (double)res.func_78328_b() / 2.0;
            boolean bl = inFrustum = vec.field_72449_c < 1.0003684;
            if (!inFrustum) {
                dx *= -1.0;
                dy *= -1.0;
            }
            double angle1 = Math.atan2(dx, dy);
            double angle2 = Math.atan2(dy, dx) * (double)57.29578f + 90.0;
            double hypotenuse = Math.hypot(dx, dy);
            double radiusInput = this.radius.getInput();
            if (this.renderItem.isToggled()) {
                radiusInput += 20.0;
            }
            if (inFrustum && hypotenuse < radiusInput + 15.0) {
                return;
            }
            double baseX = (double)res.func_78326_a() / 2.0;
            double baseY = (double)res.func_78328_b() / 2.0;
            double sinAng = Math.sin(angle1);
            double cosAng = Math.cos(angle1);
            double renderX = baseX + radiusInput * sinAng;
            double renderY = baseY + radiusInput * cosAng;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)renderX, (double)renderY, (double)0.0);
            GlStateManager.func_179114_b((float)((float)angle2), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            int arrowInput = (int)this.arrow.getInput();
            if (arrowInput == 0) {
                if (color == -1) {
                    GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                } else {
                    GL11.glColor3d((double)colorForStack.getRed(), (double)colorForStack.getGreen(), (double)colorForStack.getBlue());
                }
                GL11.glEnable((int)3042);
                GL11.glDisable((int)3553);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)2848);
                double halfAngle = 0.6108652353286743;
                double size = 9.0;
                double offsetY = 5.0;
                GL11.glLineWidth((float)3.0f);
                GL11.glBegin((int)3);
                GL11.glVertex2d((double)(Math.sin(-halfAngle) * size), (double)(Math.cos(-halfAngle) * size - offsetY));
                GL11.glVertex2d((double)0.0, (double)(-offsetY));
                GL11.glVertex2d((double)(Math.sin(halfAngle) * size), (double)(Math.cos(halfAngle) * size - offsetY));
                GL11.glEnd();
                GL11.glEnable((int)3553);
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2848);
            } else if (arrowInput == 1) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                Indicators.mc.field_71466_p.func_175065_a(">", -2.0f, -4.0f, color, false);
            } else if (arrowInput == 2) {
                RenderUtils.draw2DPolygon(0.0, 0.0, 5.0, 3, Utils.mergeAlpha(color, 255));
            }
            GlStateManager.func_179121_F();
            renderX = baseX + (radiusInput - 13.0) * sinAng;
            renderY = baseY + (radiusInput - 13.0) * cosAng;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)renderX, (double)renderY, (double)0.0);
            GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
            if (this.renderDistance.isToggled()) {
                String text = (int)Indicators.mc.field_71439_g.func_70032_d(en) + "m";
                Indicators.mc.field_71466_p.func_175065_a(text, (float)(-Indicators.mc.field_71466_p.func_78256_a(text) / 2), -4.0f, -1, true);
            }
            GlStateManager.func_179121_F();
            if (this.renderItem.isToggled() && itemStack != null) {
                GlStateManager.func_179094_E();
                if (itemStack.func_77973_b() == Items.field_151032_g) {
                    renderX = baseX + (radiusInput - 26.0) * sinAng;
                    renderY = baseY + (radiusInput - 26.0) * cosAng;
                    GlStateManager.func_179137_b((double)renderX, (double)renderY, (double)0.0);
                    GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)((float)angle2 - 45.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    mc.func_175599_af().func_175042_a(itemStack, -12, -4);
                } else {
                    renderX = baseX + (radiusInput - 29.0) * sinAng;
                    renderY = baseY + (radiusInput - 29.0) * cosAng;
                    GlStateManager.func_179137_b((double)renderX, (double)renderY, (double)0.0);
                    GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_175599_af().func_175042_a(itemStack, -8, -9);
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    private Color getColorForItem(ItemStack itemStack) {
        if (itemStack == null) {
            return Color.WHITE;
        }
        if (itemStack.func_77973_b() == Items.field_151079_bi) {
            return new Color(210, 0, 255);
        }
        if (itemStack.func_77973_b() == Items.field_151059_bz) {
            return new Color(255, 150, 0);
        }
        if (itemStack.func_77973_b() == Items.field_151110_aK) {
            return new Color(255, 238, 154);
        }
        return Color.WHITE;
    }

    private boolean shouldRender(Entity en, ItemStack stack) {
        if (this.threatsOnly.isToggled() && stack != null && stack.func_77973_b() == Items.field_151059_bz) {
            double x = en.field_70165_t;
            double y = en.field_70163_u;
            double z = en.field_70161_v;
            double dx = x - en.field_70142_S;
            double dy = y - en.field_70137_T;
            double dz = z - en.field_70136_U;
            if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
                int i = 0;
                while ((double)i < 400.0) {
                    double dist = Indicators.mc.field_71439_g.func_70092_e(x, y, z);
                    if (dist <= 36.0) {
                        return true;
                    }
                    Block block = BlockUtils.getBlock(new BlockPos(x, y, z));
                    if (!(block instanceof BlockAir) && !(block instanceof BlockLiquid) && !(block instanceof BlockFire)) break;
                    x += dx * 0.5;
                    y += dy * 0.5;
                    z += dz * 0.5;
                    ++i;
                }
            }
            return false;
        }
        return true;
    }
}

