/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.module.impl.player;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import keystrokesmod.event.ClientRotationEvent;
import keystrokesmod.event.PreUpdateEvent;
import keystrokesmod.mixin.impl.accessor.IAccessorEntityPlayerSP;
import keystrokesmod.module.Module;
import keystrokesmod.utility.BlockUtils;
import keystrokesmod.utility.RenderUtils;
import keystrokesmod.utility.RotationUtils;
import keystrokesmod.utility.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Scaffold2
extends Module {
    private PlaceObjective tempObjective;
    private MovingObjectPosition targetPlacement;
    private float[] previousRotations;

    public Scaffold2() {
        super("Scaffold2", Module.category.player);
    }

    @SubscribeEvent
    public void onClientRotation(ClientRotationEvent e) {
        if (!Utils.nullCheck() || !this.isHoldingBlocks()) {
            return;
        }
        PlaceObjective placeObjective = this.getPlaceObjective();
        this.tempObjective = null;
        if (placeObjective == null) {
            if (this.previousRotations != null) {
                e.setYaw(Float.valueOf(this.previousRotations[0]));
                e.setPitch(Float.valueOf(this.previousRotations[1]));
            }
            return;
        }
        this.tempObjective = placeObjective;
        e.setYaw(Float.valueOf(placeObjective.yaw));
        e.setPitch(Float.valueOf(placeObjective.pitch));
        this.previousRotations = new float[]{placeObjective.yaw, placeObjective.pitch};
        MovingObjectPosition rayCastWithRotations = RotationUtils.raycastBlock(Scaffold2.mc.field_71442_b.func_78757_d(), placeObjective.yaw, placeObjective.pitch);
        if (rayCastWithRotations != null && rayCastWithRotations.field_178784_b == placeObjective.rayCasted.field_178784_b && rayCastWithRotations.func_178782_a().equals((Object)placeObjective.rayCasted.func_178782_a())) {
            this.targetPlacement = rayCastWithRotations;
        }
    }

    @SubscribeEvent
    public void onPreUpdate(PreUpdateEvent e) {
        if (this.targetPlacement == null) {
            return;
        }
        this.place(this.targetPlacement);
        this.targetPlacement = null;
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent e) {
        if (this.tempObjective != null && Utils.nullCheck()) {
            RenderUtils.renderBlock(this.tempObjective.rayCasted.func_178782_a(), new Color(0, 255, 0).getRGB(), false, true);
        }
    }

    private void place(MovingObjectPosition mop) {
        ItemStack heldItem = Scaffold2.mc.field_71439_g.func_70694_bm();
        if (heldItem == null || !(heldItem.func_77973_b() instanceof ItemBlock) || !Utils.canBePlaced((ItemBlock)heldItem.func_77973_b())) {
            return;
        }
        if (Scaffold2.mc.field_71442_b.func_178890_a(Scaffold2.mc.field_71439_g, Scaffold2.mc.field_71441_e, heldItem, mop.func_178782_a(), mop.field_178784_b, mop.field_72307_f)) {
            Scaffold2.mc.field_71439_g.func_71038_i();
        }
    }

    private boolean isHoldingBlocks() {
        ItemStack heldItem = Scaffold2.mc.field_71439_g.func_70694_bm();
        return heldItem != null && heldItem.func_77973_b() instanceof ItemBlock && Utils.canBePlaced((ItemBlock)heldItem.func_77973_b());
    }

    private PlaceObjective getPlaceObjective() {
        Vec3 position = new Vec3(Scaffold2.mc.field_71439_g.field_70165_t, Scaffold2.mc.field_71439_g.field_70163_u, Scaffold2.mc.field_71439_g.field_70161_v);
        BlockPos positionBelow = new BlockPos((int)Math.floor(position.field_72450_a), (int)Math.floor(position.field_72448_b) - 1, (int)Math.floor(position.field_72449_c));
        if (this.canPlaceOn(positionBelow)) {
            return null;
        }
        Vec3 eyePositon = position.func_72441_c(0.0, (double)Scaffold2.mc.field_71439_g.func_70047_e(), 0.0);
        double reach = Scaffold2.mc.field_71442_b.func_78757_d();
        double reachSqr = reach * reach;
        double reachPlusOneSqr = (reach + 1.0) * (reach + 1.0);
        int minX = (int)Math.floor(eyePositon.field_72450_a - reach);
        int minY = (int)Math.floor(eyePositon.field_72448_b - reach - 1.0);
        int minZ = (int)Math.floor(eyePositon.field_72449_c - reach);
        int maxX = (int)Math.floor(eyePositon.field_72450_a + reach);
        int maxY = (int)Math.floor(position.field_72448_b) - 1;
        int maxZ = (int)Math.floor(eyePositon.field_72449_c + reach);
        ArrayList<PotentialBlock> candidates = new ArrayList<PotentialBlock>();
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double distance;
                    BlockPos pos;
                    double dx = (double)x + 0.5 - eyePositon.field_72450_a;
                    double dy = (double)y + 0.5 - eyePositon.field_72448_b;
                    double dz = (double)z + 0.5 - eyePositon.field_72449_c;
                    if (dx * dx + dy * dy + dz * dz > reachPlusOneSqr || !this.canPlaceOn(pos = new BlockPos(x, y, z)) || (distance = this.distanceToPointAABB(eyePositon, BlockUtils.getAABB(pos))) > reachSqr) continue;
                    candidates.add(new PotentialBlock(distance, pos));
                }
            }
        }
        candidates.sort(Comparator.comparingDouble(a -> a.distance));
        if (!candidates.isEmpty()) {
            BlockPos b = ((PotentialBlock)candidates.get((int)0)).blockPos;
            PlaceObjective res = this.getBestRotationsToBlock(Scaffold2.mc.field_71439_g.func_70694_bm(), b, eyePositon, reach);
            if (res != null) {
                return res;
            }
        }
        return null;
    }

    private PlaceObjective getBestRotationsToBlock(ItemStack held, BlockPos blockPos, Vec3 eyePosition, double reach) {
        double INSET = 0.05;
        double STEP = 0.2;
        double JIT = STEP * 0.2;
        boolean faceUP = Math.abs(eyePosition.field_72448_b - (double)(blockPos.func_177956_o() + 1)) < Math.abs(eyePosition.field_72448_b - (double)blockPos.func_177956_o());
        boolean faceSOUTH = Math.abs(eyePosition.field_72449_c - (double)(blockPos.func_177952_p() + 1)) < Math.abs(eyePosition.field_72449_c - (double)blockPos.func_177952_p());
        boolean faceEAST = Math.abs(eyePosition.field_72450_a - (double)(blockPos.func_177958_n() + 1)) < Math.abs(eyePosition.field_72450_a - (double)blockPos.func_177958_n());
        float baseYaw = this.normYaw(((IAccessorEntityPlayerSP)Scaffold2.mc.field_71439_g).getLastReportedYaw());
        float basePitch = ((IAccessorEntityPlayerSP)Scaffold2.mc.field_71439_g).getLastReportedPitch();
        int n = (int)Math.round(1.0 / STEP);
        ArrayList<Object[]> cands = new ArrayList<Object[]>((n + 1) * (n + 1) * 3 + 1);
        cands.add(new Object[]{0.0, Float.valueOf(baseYaw), Float.valueOf(basePitch)});
        for (int r = 0; r <= n; ++r) {
            double v = (double)r * STEP + Utils.randomizeDouble(-JIT, JIT);
            if (v < 0.0) {
                v = 0.0;
            } else if (v > 1.0) {
                v = 1.0;
            }
            for (int c = 0; c <= n; ++c) {
                double u = (double)c * STEP + Utils.randomizeDouble(-JIT, JIT);
                if (u < 0.0) {
                    u = 0.0;
                } else if (u > 1.0) {
                    u = 1.0;
                }
                float[] rV = this.getRotationsWrapped(eyePosition, (double)blockPos.func_177958_n() + u, faceUP ? (double)(blockPos.func_177956_o() + 1) - INSET : (double)blockPos.func_177956_o() + INSET, (double)blockPos.func_177952_p() + v);
                double costV = Math.abs((double)this.wrapYawDelta(baseYaw, rV[0])) + Math.abs((double)(rV[1] - basePitch));
                cands.add(new Object[]{costV, Float.valueOf(rV[0]), Float.valueOf(rV[1])});
                float[] rZ = this.getRotationsWrapped(eyePosition, (double)blockPos.func_177958_n() + u, (double)blockPos.func_177956_o() + v, faceSOUTH ? (double)(blockPos.func_177952_p() + 1) - INSET : (double)blockPos.func_177952_p() + INSET);
                double costZ = Math.abs((double)this.wrapYawDelta(baseYaw, rZ[0])) + Math.abs((double)(rZ[1] - basePitch));
                cands.add(new Object[]{costZ, Float.valueOf(rZ[0]), Float.valueOf(rZ[1])});
                float[] rX = this.getRotationsWrapped(eyePosition, faceEAST ? (double)(blockPos.func_177958_n() + 1) - INSET : (double)blockPos.func_177958_n() + INSET, (double)blockPos.func_177956_o() + v, (double)blockPos.func_177952_p() + u);
                double costX = Math.abs((double)this.wrapYawDelta(baseYaw, rX[0])) + Math.abs((double)(rX[1] - basePitch));
                cands.add(new Object[]{costX, Float.valueOf(rX[0]), Float.valueOf(rX[1])});
            }
        }
        cands.sort(Comparator.comparingDouble(a -> ((Number)a[0]).doubleValue()));
        MovingObjectPosition best = null;
        float bestYaw = 0.0f;
        float bestPit = 0.0f;
        for (int i = 0; i < cands.size(); ++i) {
            float pit;
            float yawW = this.unwrapYaw(((Number)((Object[])cands.get(i))[1]).floatValue(), ((IAccessorEntityPlayerSP)Scaffold2.mc.field_71439_g).getLastReportedYaw());
            MovingObjectPosition rayCastResult = RotationUtils.raycastBlock(reach, yawW, pit = ((Number)((Object[])cands.get(i))[2]).floatValue());
            if (rayCastResult == null) continue;
            BlockPos hit = rayCastResult.func_178782_a();
            EnumFacing face = rayCastResult.field_178784_b;
            int hitY = hit.func_177956_o();
            if (!hit.equals((Object)blockPos) || !((double)hitY <= Math.floor(Scaffold2.mc.field_71439_g.field_70163_u) - 1.0) || !this.canPlaceBlock(held, hit, face)) continue;
            best = rayCastResult;
            bestYaw = yawW;
            bestPit = pit;
            break;
        }
        return best != null ? new PlaceObjective(best, bestYaw, bestPit) : null;
    }

    private boolean canPlaceOn(BlockPos blockPos) {
        return !BlockUtils.replaceable(blockPos) && !BlockUtils.isInteractable(BlockUtils.getBlock(blockPos));
    }

    private boolean canPlaceBlock(ItemStack stack, BlockPos pos, EnumFacing side) {
        if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        return ((ItemBlock)stack.func_77973_b()).func_179222_a((World)Scaffold2.mc.field_71441_e, pos, side, (EntityPlayer)Scaffold2.mc.field_71439_g, stack);
    }

    private double distanceToPointAABB(Vec3 pos, AxisAlignedBB box) {
        double dx = pos.field_72450_a - Math.max(box.field_72340_a, Math.min(pos.field_72450_a, box.field_72336_d));
        double dy = pos.field_72448_b - Math.max(box.field_72338_b, Math.min(pos.field_72448_b, box.field_72337_e));
        double dz = pos.field_72449_c - Math.max(box.field_72339_c, Math.min(pos.field_72449_c, box.field_72334_f));
        return dx * dx + dy * dy + dz * dz;
    }

    private float[] getRotationsWrapped(Vec3 eye, double tx, double ty, double tz) {
        double dx = tx - eye.field_72450_a;
        double dy = ty - eye.field_72448_b;
        double dz = tz - eye.field_72449_c;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        yaw = this.normYaw(yaw);
        float pitch = (float)Math.toDegrees(-Math.atan2(dy, horizontalDist));
        return new float[]{yaw, pitch};
    }

    private float wrapYawDelta(float base, float target) {
        float delta;
        for (delta = target - base; delta <= -180.0f; delta += 360.0f) {
        }
        while (delta > 180.0f) {
            delta -= 360.0f;
        }
        return delta;
    }

    private float unwrapYaw(float yaw, float prevYaw) {
        return prevYaw + (((yaw - prevYaw + 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f);
    }

    private float normYaw(float yaw) {
        if ((yaw = (yaw % 360.0f + 360.0f) % 360.0f) > 180.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }

    public class PotentialBlock {
        public double distance;
        public BlockPos blockPos;

        public PotentialBlock(double distance, BlockPos blockPos) {
            this.distance = distance;
            this.blockPos = blockPos;
        }
    }

    public class PlaceObjective {
        public MovingObjectPosition rayCasted;
        public float yaw;
        public float pitch;

        public PlaceObjective(MovingObjectPosition rayCasted, float yaw, float pitch) {
            this.rayCasted = rayCasted;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

