/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.module.impl.minigames;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import keystrokesmod.event.PreMotionEvent;
import keystrokesmod.event.PreUpdateEvent;
import keystrokesmod.module.Module;
import keystrokesmod.module.setting.impl.ButtonSetting;
import keystrokesmod.module.setting.impl.DescriptionSetting;
import keystrokesmod.module.setting.impl.SliderSetting;
import keystrokesmod.utility.BlockUtils;
import keystrokesmod.utility.RenderUtils;
import keystrokesmod.utility.RotationUtils;
import keystrokesmod.utility.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public class WoolWars
extends Module {
    public SliderSetting breakSpeed;
    public SliderSetting range;
    public SliderSetting breakDelay;
    public SliderSetting placeDelay;
    public ButtonSetting onlyMiddleClick;
    public ButtonSetting onlyVisible;
    private final int middlePositionColors = new Color(255, 153, 204).getRGB();
    private final int miningColor = new Color(200, 100, 255).getRGB();
    private final int placeColor = new Color(150, 70, 255).getRGB();
    private BlockPos middlePos;
    private BlockPos miningPos;
    private MovingObjectPosition placeMop;
    private float curBlockDamageMP;
    private int delay;
    private int swapBack = -1;
    private double lastRange;
    private double rangeSq;
    private float placingYaw;
    private float placingPitch;
    private boolean fakeSwing;

    public WoolWars() {
        super("WoolWars", Module.category.minigames, 0);
        this.registerSetting(new DescriptionSetting("Nukes and places at control point."));
        this.breakSpeed = new SliderSetting("Break speed", 0.2, 0.0, 0.8, 0.05);
        this.registerSetting(this.breakSpeed);
        this.breakDelay = new SliderSetting("Delay after breaking", 3.0, 1.0, 10.0, 1.0);
        this.registerSetting(this.breakDelay);
        this.placeDelay = new SliderSetting("Delay after placing", 1.0, 1.0, 10.0, 1.0);
        this.registerSetting(this.placeDelay);
        this.range = new SliderSetting("Range", 5.0, 1.0, 8.0, 0.5);
        this.registerSetting(this.range);
        this.onlyVisible = new ButtonSetting("Only visible", true);
        this.registerSetting(this.onlyVisible);
        this.onlyMiddleClick = new ButtonSetting("Only while middle clicking", true);
        this.registerSetting(this.onlyMiddleClick);
    }

    @Override
    public void guiUpdate() {
        if (this.lastRange != this.range.getInput()) {
            this.lastRange = this.range.getInput();
            this.rangeSq = Math.pow(this.lastRange + 2.0, 2.0);
        }
    }

    @Override
    public void onDisable() {
        this.swapBack();
        this.reset();
    }

    @SubscribeEvent
    public void onPreUpdate(PreUpdateEvent event) {
        if (!this.isWoolWars()) {
            this.reset();
            return;
        }
        if (this.middlePos == null) {
            this.middlePos = this.getMiddlePos();
        } else if (!WoolWars.mc.field_71439_g.field_71075_bZ.field_75101_c && WoolWars.mc.field_71439_g.func_174818_b(this.middlePos) < this.rangeSq && this.isActiveRound() && (!this.onlyMiddleClick.isToggled() || Mouse.isButtonDown((int)2))) {
            if (this.swapBack == -1) {
                this.swapBack = WoolWars.mc.field_71439_g.field_71071_by.field_70461_c;
            }
            if (this.delay > 0 && --this.delay > 0) {
                if (this.fakeSwing) {
                    WoolWars.mc.field_71439_g.func_71038_i();
                }
                return;
            }
            if (this.placeMop != null) {
                return;
            }
            if (this.miningPos == null) {
                BlockPos closestPos;
                List<BlockPos> posList = this.getPossiblePos(this.middlePos, true);
                if (!posList.isEmpty() && (closestPos = this.getClosestPos(posList, true)) != null) {
                    int blockSlot = this.getBlockSlot();
                    if (blockSlot == -1) {
                        return;
                    }
                    Utils.switchSlot(blockSlot, true);
                    block0: for (int i = 0; i < 360; i += 10) {
                        float yaw = (float)((double)(WoolWars.mc.field_71439_g.field_70177_z + (float)i) + this.randomRotationOffset());
                        for (int j = 20; j < 90; j += 5) {
                            float pitch = RotationUtils.clampPitch((float)((double)j + this.randomRotationOffset()));
                            MovingObjectPosition mop = Utils.getTarget(this.lastRange, yaw, pitch);
                            if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || !BlockUtils.isBlockPosEqual(BlockUtils.offsetPos(mop), closestPos)) continue;
                            this.placeMop = mop;
                            this.placingYaw = yaw;
                            this.placingPitch = pitch;
                            break block0;
                        }
                    }
                    return;
                }
                posList = this.getPossiblePos(this.middlePos, false);
                if (posList.isEmpty()) {
                    this.middlePos = null;
                    this.swapBack();
                    return;
                }
                closestPos = this.getClosestPos(posList, false);
                if (closestPos == null) {
                    return;
                }
                this.miningPos = closestPos;
                this.switchToSlot(Utils.getTool(BlockUtils.getBlock(closestPos)));
                this.miningPos = closestPos;
                WoolWars.mc.field_71439_g.func_71038_i();
                WoolWars.startBreak(this.miningPos);
            } else if (!Utils.isPossibleToReach(this.miningPos, this.lastRange)) {
                WoolWars.abortBreak(this.miningPos);
                this.miningPos = null;
                this.delay = 0;
                this.curBlockDamageMP = 0;
                return;
            }
            this.curBlockDamageMP += BlockUtils.getBlockHardness(BlockUtils.getBlock(this.miningPos), WoolWars.mc.field_71439_g.func_70694_bm(), false, false);
            if ((double)this.curBlockDamageMP < this.breakSpeed.getInput()) {
                this.curBlockDamageMP = (float)this.breakSpeed.getInput();
            }
            if (this.curBlockDamageMP >= 1.0f) {
                WoolWars.stopBreak(this.miningPos);
                WoolWars.mc.field_71442_b.func_178888_a(this.miningPos, EnumFacing.UP);
                this.miningPos = null;
                this.curBlockDamageMP = 0.0f;
                this.delay = (int)this.breakDelay.getInput();
                this.fakeSwing = true;
            }
            WoolWars.mc.field_71441_e.func_175715_c(WoolWars.mc.field_71439_g.func_145782_y(), this.miningPos, (int)(this.curBlockDamageMP * 10.0f) - 1);
            WoolWars.mc.field_71439_g.func_71038_i();
        } else if (this.miningPos != null) {
            WoolWars.abortBreak(this.miningPos);
            this.miningPos = null;
            this.delay = 0;
            this.curBlockDamageMP = 0;
            this.swapBack();
        } else if (this.swapBack != -1) {
            this.swapBack();
        }
    }

    public double randomRotationOffset() {
        return Math.random() - 0.5;
    }

    public boolean switchToSlot(int slot) {
        if (slot == -1) {
            return false;
        }
        WoolWars.mc.field_71439_g.field_71071_by.field_70461_c = slot;
        return true;
    }

    private BlockPos getMiddlePos() {
        BlockPos pos;
        int y;
        BlockPos middlePos = null;
        int startY = y = (int)Math.floor(WoolWars.mc.field_71439_g.field_70163_u + 20.0);
        while (y > -1) {
            pos = BlockUtils.pos(0.0, y, 0.0);
            if (BlockUtils.getBlock(pos.func_177982_a(0, 0, 2)) instanceof BlockStairs || this.isControlPointBlock(pos, false)) {
                middlePos = pos;
                break;
            }
            --y;
        }
        if (middlePos == null) {
            for (y = startY; y > -1; --y) {
                pos = BlockUtils.pos(0.0, y, 6.0);
                if (!(BlockUtils.getBlock(pos.func_177982_a(0, 0, 2)) instanceof BlockStairs) && !this.isControlPointBlock(pos, false)) continue;
                middlePos = pos;
                break;
            }
        }
        return middlePos;
    }

    private List<BlockPos> getPossiblePos(BlockPos middlePos, boolean airOnly) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int zOffset = -1; zOffset <= 1; ++zOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                BlockPos pos = new BlockPos(middlePos.func_177958_n() + xOffset, middlePos.func_177956_o(), middlePos.func_177952_p() + zOffset);
                if (airOnly ? !(BlockUtils.getBlock(pos) instanceof BlockAir) : !this.isControlPointBlock(pos, true)) continue;
                posList.add(pos);
            }
        }
        return posList;
    }

    private BlockPos getClosestPos(List<BlockPos> posList, boolean down) {
        BlockPos closestPos = null;
        double leastDistSq = this.rangeSq + 1.0;
        for (BlockPos pos : posList) {
            double distSq;
            if (!Utils.isPossibleToReach(down ? pos.func_177977_b() : pos, this.lastRange) || this.onlyVisible.isToggled() && !BlockUtils.canBlockBeSeen(pos) || (distSq = WoolWars.mc.field_71439_g.func_174818_b(pos)) >= leastDistSq) continue;
            leastDistSq = distSq;
            closestPos = pos;
        }
        return closestPos;
    }

    private boolean isControlPointBlock(BlockPos pos, boolean verifyWoolColor) {
        Block block = BlockUtils.getBlock(pos);
        if (block != Blocks.field_150325_L) {
            return block == Blocks.field_150433_aE || block == Blocks.field_150371_ca;
        }
        if (!verifyWoolColor) {
            return true;
        }
        EnumDyeColor teamColor = null;
        for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            ItemStack stack = WoolWars.mc.field_71439_g.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock) || ((ItemBlock)stack.func_77973_b()).func_179223_d() != Blocks.field_150325_L) continue;
            teamColor = EnumDyeColor.func_176764_b((int)stack.func_77960_j());
            break;
        }
        return BlockUtils.getWoolColor(BlockUtils.getBlockState(pos)) != teamColor;
    }

    private boolean isActiveRound() {
        for (String line : Utils.getSidebarLines()) {
            String strip = Utils.stripString(line);
            if (!strip.contains("State: Active Round")) continue;
            return true;
        }
        return false;
    }

    public int getBlockSlot() {
        for (int slot = 0; slot < InventoryPlayer.func_70451_h(); ++slot) {
            Block block;
            ItemStack stack = WoolWars.mc.field_71439_g.field_71071_by.func_70301_a(slot);
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock) || !BlockUtils.isNormalBlock(block = ((ItemBlock)stack.func_77973_b()).func_179223_d())) continue;
            return slot;
        }
        return -1;
    }

    @SubscribeEvent
    public void onPreMotion(PreMotionEvent e) {
        float[] rotations;
        if (this.placeMop != null) {
            if (this.placingPitch > 90.0f) {
                if (WoolWars.mc.field_71442_b.func_178890_a(WoolWars.mc.field_71439_g, WoolWars.mc.field_71441_e, WoolWars.mc.field_71439_g.func_70694_bm(), this.placeMop.func_178782_a(), this.placeMop.field_178784_b, this.placeMop.field_72307_f)) {
                    WoolWars.mc.field_71439_g.func_71038_i();
                    mc.func_175597_ag().func_78444_b();
                    this.delay = (int)this.placeDelay.getInput();
                    this.fakeSwing = false;
                }
                this.placeMop = null;
            } else {
                this.placingPitch += 300.0f;
            }
            e.setYaw(this.placingYaw);
            e.setPitch(this.placingPitch - 300.0f);
            return;
        }
        if (this.miningPos != null && (rotations = RotationUtils.getRotationsToBlock(this.miningPos, EnumFacing.UP, e.getYaw(), e.getPitch())) != null) {
            e.setRotations(rotations[0], rotations[1]);
        }
        if (this.delay > 0 && (!this.onlyMiddleClick.isToggled() || Mouse.isButtonDown((int)2))) {
            float[] rotations2;
            List<BlockPos> posList = this.getPossiblePos(this.middlePos, true);
            BlockPos closestPos = null;
            if (!posList.isEmpty()) {
                closestPos = this.getClosestPos(posList, true);
            }
            if (closestPos == null) {
                posList = this.getPossiblePos(this.middlePos, false);
                closestPos = this.getClosestPos(posList, false);
            }
            if (closestPos != null && (rotations2 = RotationUtils.getRotationsToBlock(closestPos, EnumFacing.UP, e.getYaw(), e.getPitch())) != null) {
                e.setRotations(rotations2[0], rotations2[1]);
            }
        }
    }

    private boolean isWoolWars() {
        if (!Utils.nullCheck() || !Utils.isHypixel()) {
            return false;
        }
        Scoreboard scoreboard = WoolWars.mc.field_71441_e.func_96441_U();
        if (scoreboard == null) {
            return false;
        }
        ScoreObjective objective = scoreboard.func_96539_a(1);
        return objective != null && Utils.stripString(objective.func_96678_d()).contains("WOOL WARS");
    }

    private void swapBack() {
        if (this.swapBack != -1) {
            WoolWars.mc.field_71439_g.field_71071_by.field_70461_c = this.swapBack;
            this.swapBack = -1;
        }
    }

    private void reset() {
        this.miningPos = null;
        this.middlePos = null;
        this.placeMop = null;
        this.delay = 0;
        this.curBlockDamageMP = 0;
        this.swapBack = -1;
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent e) {
        if (!Utils.nullCheck()) {
            return;
        }
        if (this.middlePos != null) {
            for (BlockPos pos : this.getPossiblePos(this.middlePos, false)) {
                RenderUtils.renderBlock(pos, this.middlePositionColors, true, false);
            }
        }
        if (this.miningPos != null) {
            RenderUtils.renderBlock(this.miningPos, this.miningColor, false, true);
        } else if (this.placeMop != null) {
            RenderUtils.renderBlock(BlockUtils.offsetPos(this.placeMop), this.placeColor, false, true);
        }
    }

    @SubscribeEvent
    public void onMouse(MouseEvent e) {
        if (e.button == 0) {
            if (e.buttonstate && (this.miningPos != null || this.placeMop != null)) {
                e.setCanceled(true);
            }
        } else if (e.button == 1 && (this.miningPos != null || this.placeMop != null)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldJoin(EntityJoinWorldEvent e) {
        if (e.entity == WoolWars.mc.field_71439_g) {
            this.reset();
        }
    }

    public static void startBreak(BlockPos pos) {
        WoolWars.mc.field_71439_g.field_71174_a.func_147297_a((Packet)new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, EnumFacing.UP));
    }

    public static void stopBreak(BlockPos pos) {
        WoolWars.mc.field_71439_g.field_71174_a.func_147297_a((Packet)new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, EnumFacing.UP));
    }

    public static void abortBreak(BlockPos pos) {
        WoolWars.mc.field_71439_g.field_71174_a.func_147297_a((Packet)new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.ABORT_DESTROY_BLOCK, pos, EnumFacing.DOWN));
    }
}

