/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.module.impl.minigames;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import keystrokesmod.event.PreUpdateEvent;
import keystrokesmod.event.ReceivePacketEvent;
import keystrokesmod.mixin.impl.accessor.IAccessorMinecraft;
import keystrokesmod.module.Module;
import keystrokesmod.module.setting.impl.ButtonSetting;
import keystrokesmod.module.setting.impl.DescriptionSetting;
import keystrokesmod.module.setting.impl.SliderSetting;
import keystrokesmod.utility.BlockUtils;
import keystrokesmod.utility.RenderUtils;
import keystrokesmod.utility.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.S08PacketPlayerPosLook;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpeedBuilders
extends Module {
    private SliderSetting placeDelay;
    private ButtonSetting antiMiss;
    private ButtonSetting autoPlace;
    private ButtonSetting autoSwap;
    private ButtonSetting hoverPlace;
    private ButtonSetting infoHud;
    private ButtonSetting renderBlocks;
    private ButtonSetting renderOnlyPlaceable;
    private ConcurrentHashMap<BlockPos, BuildBlockInfo> buildInfo = new ConcurrentHashMap();
    private BlockPos platformCenter;
    private boolean listenForPacket;
    public List<BlockPos> platformPositions = Arrays.asList(new BlockPos(45, 71, -18), new BlockPos(-16, 71, 45), new BlockPos(18, 71, 45), new BlockPos(45, 71, 16), new BlockPos(-18, 71, -45), new BlockPos(-45, 71, -16), new BlockPos(-45, 71, 18), new BlockPos(16, 71, -45));
    private int highlightColor = new Color(31, 255, 22, 44).getRGB();
    private int notPlaceableColor = new Color(184, 255, 183, 30).getRGB();
    private boolean doneCollecting;
    private double blockCount;
    private int lastPlaceTick = 0;
    private boolean eliminated;

    public SpeedBuilders() {
        super("Speed Builders", Module.category.minigames);
        this.registerSetting(new DescriptionSetting("Middle click to toggle auto."));
        this.placeDelay = new SliderSetting("Place delay", " tick", 0.5, 0.0, 10.0, 0.5);
        this.registerSetting(this.placeDelay);
        this.antiMiss = new ButtonSetting("Anti miss", false);
        this.registerSetting(this.antiMiss);
        this.autoPlace = new ButtonSetting("Auto place", false);
        this.registerSetting(this.autoPlace);
        this.autoSwap = new ButtonSetting("Auto swap", true);
        this.registerSetting(this.autoSwap);
        this.hoverPlace = new ButtonSetting("Hover place", true);
        this.registerSetting(this.hoverPlace);
        this.infoHud = new ButtonSetting("Info HUD", true);
        this.registerSetting(this.infoHud);
        this.renderBlocks = new ButtonSetting("Render blocks", true);
        this.registerSetting(this.renderBlocks);
        this.renderOnlyPlaceable = new ButtonSetting("Render only placeable", false);
        this.registerSetting(this.renderOnlyPlaceable);
    }

    @Override
    public void onDisable() {
        this.lastPlaceTick = 0;
    }

    @SubscribeEvent
    public void onPreUpdate(PreUpdateEvent e) {
        int gameStatus = this.getGameStatus();
        if (gameStatus == -1 || this.platformCenter == null) {
            return;
        }
        if (gameStatus == 4) {
            this.doneCollecting = true;
        }
        if (gameStatus == 1 && !this.doneCollecting) {
            this.buildInfo = this.getBuildInfo(this.platformCenter);
            if (!this.buildInfo.isEmpty()) {
                this.blockCount = this.buildInfo.size();
            }
        }
        if (gameStatus == 2) {
            this.doneCollecting = false;
            for (Map.Entry<BlockPos, BuildBlockInfo> entry : this.buildInfo.entrySet()) {
                IBlockState currentState = SpeedBuilders.mc.field_71441_e.func_180495_p(entry.getKey());
                IBlockState requiredState = entry.getValue().requiredState;
                if (currentState == null || requiredState == null) {
                    entry.getValue().isPlaced = false;
                    continue;
                }
                if (currentState.equals(requiredState) || requiredState.func_177230_c() instanceof BlockLeaves && currentState.func_177230_c().equals(requiredState.func_177230_c())) {
                    entry.getValue().isPlaced = true;
                    continue;
                }
                entry.getValue().isPlaced = false;
            }
            if (this.getLookInfo() != null) {
                BlockPos targetPos;
                BlockPos facePos;
                BuildBlockInfo info;
                MovingObjectPosition mop = this.getLookInfo();
                if (mop.field_178784_b != null && (info = this.buildInfo.get(facePos = (targetPos = mop.func_178782_a()).func_177972_a(mop.field_178784_b))) != null && !info.isPlaced) {
                    if (this.autoSwap.isToggled()) {
                        int requiredMeta = info.requiredState.func_177230_c().func_176201_c(info.requiredState);
                        int slot = this.getSlot(info.requiredState.func_177230_c(), requiredMeta);
                        if (slot != -1 && slot != SpeedBuilders.mc.field_71439_g.field_71071_by.field_70461_c) {
                            SpeedBuilders.mc.field_71439_g.field_71071_by.field_70461_c = slot;
                        }
                    }
                    if (this.hoverPlace.isToggled() && this.holdingSameBlock(info.requiredState) && this.correctPlaceState(info.requiredState, targetPos, mop.field_178784_b, mop.field_72307_f, SpeedBuilders.mc.field_71439_g.func_70694_bm())) {
                        int n = this.lastPlaceTick++;
                        if ((double)n < this.placeDelay.getInput()) {
                            return;
                        }
                        ((IAccessorMinecraft)mc).callRightClickMouse();
                        this.lastPlaceTick = 0;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouse(MouseEvent e) {
        if (!e.buttonstate || !Utils.nullCheck() || SpeedBuilders.mc.field_71462_r != null) {
            return;
        }
        if (e.button == 1 && this.antiMiss.isToggled() && this.getLookInfo() != null && this.getGameStatus() == 2) {
            BlockPos targetPos;
            BlockPos facePos;
            BuildBlockInfo info;
            MovingObjectPosition mop = this.getLookInfo();
            if (!(mop.field_178784_b == null || (info = this.buildInfo.get(facePos = (targetPos = mop.func_178782_a()).func_177972_a(mop.field_178784_b))) != null && this.holdingSameBlock(info.requiredState) && this.correctPlaceState(info.requiredState, targetPos, mop.field_178784_b, mop.field_72307_f, SpeedBuilders.mc.field_71439_g.func_70694_bm()))) {
                e.setCanceled(true);
            }
        } else if (e.button == 2) {
            if (this.autoSwap.isToggled()) {
                this.autoSwap.disable();
                this.hoverPlace.disable();
            } else {
                this.autoSwap.enable();
                this.hoverPlace.enable();
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent ev) {
        if (!Utils.nullCheck() || this.getGameStatus() != 2 || !this.renderBlocks.isToggled()) {
            return;
        }
        for (Map.Entry<BlockPos, BuildBlockInfo> buildData : this.buildInfo.entrySet()) {
            BuildBlockInfo info = buildData.getValue();
            if (info.isPlaced || !this.holdingSameBlock(info.requiredState)) continue;
            BlockPos pos = buildData.getKey();
            boolean useWhite = true;
            for (EnumFacing dir : EnumFacing.values()) {
                BlockPos neighborPos = pos.func_177972_a(dir);
                if (BlockUtils.getBlock(neighborPos) == Blocks.field_150350_a) continue;
                useWhite = false;
            }
            if (this.renderOnlyPlaceable.isToggled() && useWhite) continue;
            RenderUtils.renderBlockModel(buildData.getValue().requiredState, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), useWhite ? this.notPlaceableColor : this.highlightColor);
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent e) {
        if (e.phase != TickEvent.Phase.END || !Utils.nullCheck() || SpeedBuilders.mc.field_71462_r != null) {
            return;
        }
        int gameStatus = this.getGameStatus();
        if (this.infoHud.isToggled()) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("\u00a76Speed Builders");
            lines.add("\u00a77Status: \u00a7b" + (gameStatus == 1 || gameStatus == 4 ? "Showing" : (gameStatus == 2 ? "Building" : (gameStatus == 3 ? "Judging" : "\u00a7cDisabled"))));
            if (gameStatus == 2 && !this.eliminated) {
                double placedCount = 0.0;
                for (BuildBlockInfo info : this.buildInfo.values()) {
                    if (!info.isPlaced) continue;
                    placedCount += 1.0;
                }
                double percentage = 0.0;
                if (this.buildInfo.isEmpty()) {
                    percentage = 100.0;
                    placedCount = this.blockCount;
                } else if (this.blockCount > 0.0) {
                    percentage = placedCount / this.blockCount * 100.0;
                }
                lines.add("\u00a77Progress: \u00a7b" + (int)placedCount + "\u00a77/\u00a7b" + (int)this.blockCount + " " + Math.round(percentage) + "%");
            }
            lines.add("\u00a77Auto: " + (this.autoEnabled() ? "\u00a7aENABLED" : "\u00a7cDISABLED"));
            int padding = 4;
            int maxWidth = 0;
            for (String line : lines) {
                int lineWidth = SpeedBuilders.mc.field_71466_p.func_78256_a(line);
                if (lineWidth <= maxWidth) continue;
                maxWidth = lineWidth;
            }
            int lineHeight = SpeedBuilders.mc.field_71466_p.field_78288_b;
            int lineSpacing = 3;
            int totalHeight = lines.size() * lineHeight + (lines.size() - 1) * lineSpacing + padding * 2;
            int totalWidth = maxWidth + padding * 2;
            float x = -5.0f;
            float y = 110.0f;
            RenderUtils.drawRoundedRectangle(x, y, x + (float)totalWidth + 7.0f, y + (float)totalHeight - 2.0f, 7.0f, Utils.mergeAlpha(Color.black.getRGB(), 120));
            float textX = x + (float)padding;
            float textY = y + (float)padding;
            for (int i = 0; i < lines.size(); ++i) {
                SpeedBuilders.mc.field_71466_p.func_78276_b((String)lines.get(i), (int)(textX + 5.0f), (int)(textY + (float)(i * (lineHeight + lineSpacing))), -1);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent e) {
        if (!Utils.nullCheck() || e.entity == null) {
            return;
        }
        if (e.entity == SpeedBuilders.mc.field_71439_g) {
            this.buildInfo.clear();
            this.platformCenter = null;
            this.listenForPacket = false;
            this.doneCollecting = false;
            this.eliminated = false;
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        if (e.type == 2 || !Utils.nullCheck() || this.getGameStatus() == -1 || this.listenForPacket) {
            return;
        }
        String stripped = Utils.stripColor(e.message.func_150260_c());
        if (stripped.isEmpty()) {
            return;
        }
        if (stripped.contains("Perfectly recreate the build you are shown each") || stripped.contains("The game starts in 1 second!")) {
            this.listenForPacket = true;
        }
        if (stripped.startsWith(Utils.getServerName()) && stripped.contains(" got a perfect build in ") && stripped.endsWith("s!")) {
            this.buildInfo.clear();
            this.doneCollecting = false;
        }
        if (stripped.startsWith("Player eliminated: " + Utils.getServerName()) && stripped.endsWith("%)")) {
            this.eliminated = true;
        }
    }

    @SubscribeEvent
    public void onReceivePacket(ReceivePacketEvent e) {
        if (this.listenForPacket && Utils.nullCheck() && e.getPacket() instanceof S08PacketPlayerPosLook) {
            Vec3 setPos = new Vec3(((S08PacketPlayerPosLook)e.getPacket()).func_148932_c(), ((S08PacketPlayerPosLook)e.getPacket()).func_148928_d(), ((S08PacketPlayerPosLook)e.getPacket()).func_148933_e());
            if (this.platformCenter == null) {
                this.platformCenter = this.findCenter(setPos);
            }
            this.listenForPacket = false;
        }
    }

    public int getGameStatus() {
        List<String> sidebar = Utils.getSidebarLines();
        if (sidebar == null || sidebar.isEmpty()) {
            return -1;
        }
        if (!Utils.stripColor(sidebar.get(0)).startsWith("BUILD BATTLE")) {
            return -1;
        }
        for (int i = 0; i < sidebar.size() - 1; ++i) {
            String currentLine = Utils.stripColor(sidebar.get(i));
            String nextLine = Utils.stripColor(sidebar.get(i + 1));
            if (!currentLine.startsWith("Round:")) continue;
            if (nextLine.startsWith("Starts In: 00:03") && Utils.stripColor(sidebar.get(i + 3)).startsWith("Theme:")) {
                return 4;
            }
            if (nextLine.startsWith("Starts In:")) {
                return 1;
            }
            if (nextLine.startsWith("Time Left:")) {
                return 2;
            }
            if (!nextLine.startsWith("Judging:")) continue;
            return 3;
        }
        return 0;
    }

    public BlockPos findCenter(Vec3 position) {
        BlockPos closestPos = null;
        double closestDistSq = Double.MAX_VALUE;
        double maxDistance = 30.0;
        double maxDistSq = maxDistance * maxDistance;
        for (BlockPos pos : this.platformPositions) {
            double dz;
            double dy;
            double dx = (double)pos.func_177958_n() - position.field_72450_a;
            double distSq = Math.abs(dx * dx + (dy = (double)pos.func_177956_o() - position.field_72448_b) * dy + (dz = (double)pos.func_177952_p() - position.field_72449_c) * dz);
            if (!(distSq <= maxDistSq) || !(distSq < closestDistSq)) continue;
            closestDistSq = distSq;
            closestPos = pos;
        }
        return closestPos;
    }

    public ConcurrentHashMap<BlockPos, BuildBlockInfo> getBuildInfo(BlockPos centerPos) {
        ConcurrentHashMap<BlockPos, BuildBlockInfo> blockInfo = new ConcurrentHashMap<BlockPos, BuildBlockInfo>();
        int startX = centerPos.func_177958_n() - 3;
        int endX = centerPos.func_177958_n() + 3;
        int startZ = centerPos.func_177952_p() - 3;
        int endZ = centerPos.func_177952_p() + 3;
        int startY = centerPos.func_177956_o() + 1;
        int endY = startY + 30;
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int y = startY; y <= endY; ++y) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState state = SpeedBuilders.mc.field_71441_e.func_180495_p(currentPos);
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    blockInfo.put(currentPos, new BuildBlockInfo(state));
                }
            }
        }
        return blockInfo;
    }

    public boolean autoEnabled() {
        return this.autoSwap.isToggled() && this.hoverPlace.isToggled();
    }

    public boolean holdingSameBlock(IBlockState requiredState) {
        if (SpeedBuilders.mc.field_71439_g == null || requiredState == null) {
            return false;
        }
        ItemStack heldItem = SpeedBuilders.mc.field_71439_g.func_70694_bm();
        if (heldItem == null) {
            return false;
        }
        Item item = heldItem.func_77973_b();
        Block requiredBlock = requiredState.func_177230_c();
        if ((requiredBlock == Blocks.field_150355_j || requiredBlock == Blocks.field_150358_i) && item == Items.field_151131_as) {
            return true;
        }
        if (!(item instanceof ItemBlock)) {
            return false;
        }
        Block heldBlock = ((ItemBlock)item).func_179223_d();
        int heldMeta = heldItem.func_77952_i();
        int requiredMeta = requiredBlock.func_176201_c(requiredState);
        if (requiredBlock == Blocks.field_150362_t || requiredBlock == Blocks.field_150361_u) {
            requiredMeta &= 3;
            heldMeta &= 3;
        }
        if (this.removeMeta(heldBlock)) {
            heldMeta = 0;
            requiredMeta = 0;
        }
        return heldBlock == requiredBlock && heldMeta == requiredMeta;
    }

    public MovingObjectPosition getLookInfo() {
        MovingObjectPosition movingObjectPosition = SpeedBuilders.mc.field_71476_x;
        if (movingObjectPosition == null || movingObjectPosition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || movingObjectPosition.func_178782_a() == null) {
            return null;
        }
        return SpeedBuilders.mc.field_71476_x;
    }

    private int getSlot(Block block, int meta) {
        if (this.removeMeta(block)) {
            meta = 0;
        }
        if (block == Blocks.field_150362_t || block == Blocks.field_150361_u) {
            meta &= 3;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = SpeedBuilders.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemBlock) || itemStack.field_77994_a <= 0) continue;
            Block invBlock = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
            int invMeta = itemStack.func_77952_i();
            if (this.removeMeta(block)) {
                invMeta = 0;
            }
            if (invBlock == Blocks.field_150362_t || invBlock == Blocks.field_150361_u) {
                invMeta &= 3;
            }
            if (invBlock != block || invMeta != meta) continue;
            return i;
        }
        return -1;
    }

    private boolean removeMeta(Block block) {
        return block instanceof BlockStairs || block instanceof BlockDoublePlant || block instanceof BlockFlower || block instanceof BlockSkull || block instanceof BlockLadder || block instanceof BlockPumpkin || block instanceof BlockCauldron || block instanceof BlockRail || block instanceof BlockRailBase || block instanceof BlockTripWireHook || block instanceof BlockTripWire || block instanceof BlockDispenser || block instanceof BlockDropper || block instanceof BlockHopper || block instanceof BlockTorch || block instanceof BlockButton || block instanceof BlockLever || block instanceof BlockTrapDoor || block instanceof BlockSlab;
    }

    private boolean correctPlaceState(IBlockState requiredState, BlockPos blockPos, EnumFacing enumFacing, Vec3 hitVec, ItemStack heldItem) {
        EnumFacing requiredFacing;
        EnumFacing simulatedFacing;
        int requiredMeta;
        if (requiredState == null || blockPos == null || enumFacing == null || hitVec == null || heldItem == null || !(heldItem.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        if (requiredState.func_177230_c() instanceof BlockLeaves || requiredState.func_177230_c() instanceof BlockButton) {
            return true;
        }
        ItemBlock itemBlock = (ItemBlock)heldItem.func_77973_b();
        Block block = itemBlock.func_179223_d();
        int meta = heldItem.func_77952_i();
        Vec3 relativeHitVec = hitVec.func_178788_d(new Vec3((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()));
        IBlockState simulatedState = block.func_180642_a((World)SpeedBuilders.mc.field_71441_e, blockPos, enumFacing, (float)relativeHitVec.field_72450_a, (float)relativeHitVec.field_72448_b, (float)relativeHitVec.field_72449_c, meta, (EntityLivingBase)SpeedBuilders.mc.field_71439_g);
        if (simulatedState == null) {
            return false;
        }
        if (simulatedState.func_177230_c() != requiredState.func_177230_c()) {
            return false;
        }
        int simulatedMeta = simulatedState.func_177230_c().func_176201_c(simulatedState);
        if (simulatedMeta != (requiredMeta = requiredState.func_177230_c().func_176201_c(requiredState))) {
            return false;
        }
        if (simulatedState.func_177228_b().containsKey((Object)BlockDirectional.field_176387_N) && requiredState.func_177228_b().containsKey((Object)BlockDirectional.field_176387_N) && (simulatedFacing = (EnumFacing)simulatedState.func_177229_b((IProperty)BlockDirectional.field_176387_N)) != (requiredFacing = (EnumFacing)requiredState.func_177229_b((IProperty)BlockDirectional.field_176387_N))) {
            return false;
        }
        if (simulatedState.func_177230_c() instanceof BlockStairs && requiredState.func_177230_c() instanceof BlockStairs) {
            simulatedFacing = (EnumFacing)simulatedState.func_177229_b((IProperty)BlockStairs.field_176309_a);
            requiredFacing = (EnumFacing)requiredState.func_177229_b((IProperty)BlockStairs.field_176309_a);
            BlockStairs.EnumHalf simulatedHalf = (BlockStairs.EnumHalf)simulatedState.func_177229_b((IProperty)BlockStairs.field_176308_b);
            BlockStairs.EnumHalf requiredHalf = (BlockStairs.EnumHalf)requiredState.func_177229_b((IProperty)BlockStairs.field_176308_b);
            if (simulatedFacing != requiredFacing || simulatedHalf != requiredHalf) {
                return false;
            }
        }
        return true;
    }

    class BuildBlockInfo {
        public IBlockState requiredState;
        public boolean isPlaced;

        public BuildBlockInfo(IBlockState state) {
            this.requiredState = state;
            this.isPlaced = false;
        }
    }
}

