/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.module.impl.minigames;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import keystrokesmod.event.PreUpdateEvent;
import keystrokesmod.event.SendPacketEvent;
import keystrokesmod.event.UseItemEvent;
import keystrokesmod.module.Module;
import keystrokesmod.module.ModuleManager;
import keystrokesmod.module.impl.world.AntiBot;
import keystrokesmod.module.setting.impl.ButtonSetting;
import keystrokesmod.utility.RenderUtils;
import keystrokesmod.utility.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SkyWars
extends Module {
    public ButtonSetting strengthIndicator;
    public ButtonSetting onlyAuraHostileMobs;
    public ButtonSetting renderTimeWarp;
    public Map<EntityPlayer, Long> strengthPlayers = new HashMap<EntityPlayer, Long>();
    private Map<String, SpawnEggInfo> entitySpawnQueue = new LinkedHashMap<String, SpawnEggInfo>();
    private Map<Vec3, Long> timeWarpPositions = new LinkedHashMap<Vec3, Long>();
    public List<Integer> spawnedMobs = new ArrayList<Integer>();
    private final int strengthColor = new Color(255, 0, 0).getRGB();
    private final int timeWarpColor = new Color(210, 0, 255, 64).getRGB();
    private String[] killMessages = new String[]{" by ", " to ", " with ", " of ", " from ", " knight ", " for "};
    private boolean thrownPearl;
    public static boolean isSkyWarsTeams = false;

    public SkyWars() {
        super("Sky Wars", Module.category.minigames);
        this.onlyAuraHostileMobs = new ButtonSetting("Only aura hostile mobs", true);
        this.registerSetting(this.onlyAuraHostileMobs);
        this.renderTimeWarp = new ButtonSetting("Render time warp", true);
        this.registerSetting(this.renderTimeWarp);
        this.strengthIndicator = new ButtonSetting("Strength indicator", true);
        this.registerSetting(this.strengthIndicator);
    }

    @Override
    public void onDisable() {
        this.clear();
    }

    @SubscribeEvent
    public void onPreUpdate(PreUpdateEvent e) {
        if (!this.strengthIndicator.isToggled() || !Utils.nullCheck() || this.strengthPlayers.isEmpty() || Utils.getSkyWarsStatus() != 2) {
            return;
        }
        int customMode = this.getCustomMode();
        if (customMode == 2) {
            return;
        }
        isSkyWarsTeams = customMode == 1;
        long duration = isSkyWarsTeams ? 2000L : 5000L;
        ArrayList<EntityPlayer> keysList = new ArrayList<EntityPlayer>(this.strengthPlayers.keySet());
        for (EntityPlayer entityPlayer : keysList) {
            long storedTime = this.strengthPlayers.get(entityPlayer);
            long timePassed = System.currentTimeMillis() - storedTime;
            if (timePassed < duration && !AntiBot.isBot((Entity)entityPlayer)) continue;
            this.strengthPlayers.remove(entityPlayer);
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        if (e.type == 2 || !Utils.nullCheck()) {
            return;
        }
        String stripped = Utils.stripColor(e.message.func_150260_c());
        if (stripped.isEmpty()) {
            return;
        }
        if (stripped.equals("You will be warped back in 3 seconds!") && this.thrownPearl) {
            this.timeWarpPositions.put(new Vec3(SkyWars.mc.field_71439_g.field_70142_S, SkyWars.mc.field_71439_g.field_70137_T, SkyWars.mc.field_71439_g.field_70136_U), System.currentTimeMillis());
            this.thrownPearl = false;
            return;
        }
        if (this.strengthIndicator.isToggled() && Utils.getSkyWarsStatus() == 2) {
            if (this.getCustomMode() == 2) {
                return;
            }
            if (stripped.endsWith(".")) {
                if (Arrays.stream(this.killMessages).anyMatch(stripped::contains)) {
                    String[] parts;
                    block0: for (String part : parts = stripped.split(" ")) {
                        if (!part.endsWith(".")) continue;
                        String name = part.substring(0, part.length() - 1);
                        for (EntityPlayer entity : SkyWars.mc.field_71441_e.field_73010_i) {
                            if (!entity.func_70005_c_().trim().equals(name) || entity == SkyWars.mc.field_71439_g) continue;
                            this.strengthPlayers.put(entity, System.currentTimeMillis());
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent e) {
        if (!Utils.nullCheck() || Utils.getSkyWarsStatus() != 2) {
            return;
        }
        if (this.strengthIndicator.isToggled()) {
            for (EntityPlayer entityPlayer : this.strengthPlayers.keySet()) {
                if (AntiBot.isBot((Entity)entityPlayer)) continue;
                RenderUtils.renderEntity((Entity)entityPlayer, 2, 0.0, 0.0, this.strengthColor, false);
            }
        }
        if (this.renderTimeWarp.isToggled()) {
            Iterator<Map.Entry<Vec3, Long>> iterator = this.timeWarpPositions.entrySet().iterator();
            long currentTime = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Map.Entry<Vec3, Long> entry = iterator.next();
                Vec3 position = entry.getKey();
                long timeThrown = entry.getValue();
                if (currentTime - timeThrown >= 3050L) {
                    iterator.remove();
                    continue;
                }
                RenderUtils.drawPlayerBoundingBox(position, this.timeWarpColor);
            }
        }
    }

    @SubscribeEvent
    public void onWorldJoin(EntityJoinWorldEvent e) {
        if (e.entity == SkyWars.mc.field_71439_g) {
            this.clear();
        } else if (e.entity != null) {
            if (Utils.getSkyWarsStatus() != 2) {
                return;
            }
            String entityClassName = e.entity.getClass().getSimpleName();
            if (this.entitySpawnQueue.containsKey(entityClassName)) {
                Vec3 spawnPosition = new Vec3(e.entity.field_70165_t, e.entity.field_70163_u, e.entity.field_70161_v);
                SpawnEggInfo eggInfo = this.entitySpawnQueue.get(entityClassName);
                if (eggInfo.spawnPos.func_72438_d(spawnPosition) > 3.0 || Utils.timeBetween(SkyWars.mc.field_71439_g.field_70173_aa, eggInfo.tickSpawned) > 60L) {
                    return;
                }
                if (!this.entitySpawnQueue.remove(entityClassName, eggInfo)) {
                    return;
                }
                this.spawnedMobs.add(e.entity.func_145782_y());
            }
        }
    }

    @SubscribeEvent
    public void onSendPacket(SendPacketEvent e) {
        C08PacketPlayerBlockPlacement p;
        if (e.getPacket() instanceof C08PacketPlayerBlockPlacement && (p = (C08PacketPlayerBlockPlacement)e.getPacket()).func_149568_f() != 255 && p.func_149574_g() != null && p.func_149574_g().func_77973_b() != null) {
            if (!(p.func_149574_g().func_77973_b() instanceof ItemMonsterPlacer)) {
                return;
            }
            Class oclass = (Class)EntityList.field_75625_b.get(ItemMonsterPlacer.getEntityName((ItemStack)p.func_149574_g()));
            if (oclass == null) {
                return;
            }
            this.entitySpawnQueue.put(oclass.getSimpleName(), new SpawnEggInfo(p.func_179724_a(), SkyWars.mc.field_71439_g.field_70173_aa));
        }
    }

    @SubscribeEvent
    public void onUseItem(UseItemEvent e) {
        if (e.usedItemStack != null && e.usedItemStack.func_77973_b() instanceof ItemEnderPearl && Utils.getSkyWarsStatus() == 2) {
            List toolTip;
            ItemStack stack = e.usedItemStack;
            if (Utils.stripString(stack.func_82833_r()).equals("Time Warp Pearl")) {
                this.thrownPearl = true;
            } else if (stack.func_82833_r().startsWith("\u00a7b\u00a7l") && (toolTip = stack.func_82840_a((EntityPlayer)SkyWars.mc.field_71439_g, true)) != null && toolTip.size() > 1 && Utils.stripString((String)toolTip.get(1)).contains("Teleports you back to your")) {
                this.thrownPearl = true;
            }
        }
    }

    private void clear() {
        this.strengthPlayers.clear();
        this.spawnedMobs.clear();
        this.entitySpawnQueue.clear();
        this.timeWarpPositions.clear();
        this.thrownPearl = false;
    }

    public static boolean onlyAuraHostiles() {
        return ModuleManager.skyWars != null && ModuleManager.skyWars.isEnabled() && ModuleManager.skyWars.onlyAuraHostileMobs.isToggled() && Utils.getSkyWarsStatus() == 2;
    }

    public int getCustomMode() {
        List<String> sidebar = Utils.getSidebarLines();
        if (sidebar == null || sidebar.isEmpty()) {
            return -1;
        }
        for (String line : sidebar) {
            if ((line = Utils.stripColor(line)).startsWith("Teams left: ")) {
                return 1;
            }
            if (!line.startsWith("Lab: ")) continue;
            return 2;
        }
        return -1;
    }

    public static class SpawnEggInfo {
        public Vec3 spawnPos;
        public int tickSpawned;

        public SpawnEggInfo(BlockPos spawnPos, int tickSpawned) {
            this.spawnPos = new Vec3((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
            this.tickSpawned = tickSpawned;
        }
    }
}

