/*
 * Decompiled with CFR 0.152.
 */
package keystrokesmod.helper;

import keystrokesmod.event.ClientRotationEvent;
import keystrokesmod.event.GameTickEvent;
import keystrokesmod.event.JumpEvent;
import keystrokesmod.event.PostPlayerInputEvent;
import keystrokesmod.event.PreMotionEvent;
import keystrokesmod.event.PreUpdateEvent;
import keystrokesmod.event.StrafeEvent;
import keystrokesmod.module.impl.client.Settings;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RotationHelper {
    private static RotationHelper INSTANCE = new RotationHelper();
    private Float serverYaw = null;
    private Float serverPitch = null;
    private boolean setRotations = false;
    public boolean forceMovementFix = false;
    private Minecraft mc = Minecraft.func_71410_x();
    public float yawOffset = 0.0f;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPreUpdate(PreUpdateEvent e) {
        ClientRotationEvent event = new ClientRotationEvent(this.serverYaw, this.serverPitch);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.yaw != null && !event.yaw.isNaN()) {
            this.serverYaw = event.yaw;
            this.setRotations = true;
        }
        if (event.pitch != null && !event.pitch.isNaN()) {
            this.serverPitch = event.pitch;
            this.setRotations = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreMotion(PreMotionEvent e) {
        if (!this.setRotations) {
            return;
        }
        if (this.serverYaw != null && !this.serverYaw.isNaN()) {
            e.setYaw(this.serverYaw.floatValue() + this.yawOffset);
        }
        if (this.serverPitch != null && !this.serverPitch.isNaN()) {
            e.setPitch(this.serverPitch.floatValue());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onStrafe(StrafeEvent e) {
        if (this.fixMovement()) {
            e.setYaw(this.serverYaw.floatValue() + this.yawOffset);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onJump(JumpEvent e) {
        if (this.fixMovement()) {
            e.setYaw(this.serverYaw.floatValue() + this.yawOffset);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPostInput(PostPlayerInputEvent event) {
        if (!this.fixMovement()) {
            return;
        }
        float sneakMultiplier = this.mc.field_71439_g.field_71158_b.field_78899_d ? 0.3f : 1.0f;
        float yaw = this.serverYaw.floatValue() + this.yawOffset;
        float forward = this.mc.field_71439_g.field_71158_b.field_78900_b;
        float strafe = this.mc.field_71439_g.field_71158_b.field_78902_a;
        if (forward == 0.0f && strafe == 0.0f) {
            return;
        }
        double angle = MathHelper.func_76138_g((double)Math.toDegrees(RotationHelper.getDirection(this.mc.field_71439_g.field_70177_z + this.yawOffset, forward, strafe)));
        float closestForward = 0.0f;
        float closestStrafe = 0.0f;
        float closestDifference = Float.MAX_VALUE;
        for (float pfRaw = -1.0f; pfRaw <= 1.0f; pfRaw += 1.0f) {
            for (float psRaw = -1.0f; psRaw <= 1.0f; psRaw += 1.0f) {
                float predictedStrafe;
                float predictedForward;
                double predictedAngle;
                double difference;
                if (pfRaw == 0.0f && psRaw == 0.0f || !((difference = Math.abs(angle - (predictedAngle = MathHelper.func_76138_g((double)Math.toDegrees(RotationHelper.getDirection(yaw, predictedForward = pfRaw * sneakMultiplier, predictedStrafe = psRaw * sneakMultiplier)))))) < (double)closestDifference)) continue;
                closestDifference = (float)difference;
                closestForward = predictedForward;
                closestStrafe = predictedStrafe;
            }
        }
        this.mc.field_71439_g.field_71158_b.field_78900_b = closestForward;
        this.mc.field_71439_g.field_71158_b.field_78902_a = closestStrafe;
        Settings.fixedForward = closestForward;
        Settings.fixedStrafe = closestStrafe;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRunTick(GameTickEvent e) {
        this.serverPitch = null;
        this.serverYaw = null;
        this.forceMovementFix = false;
        this.setRotations = false;
    }

    private boolean fixMovement() {
        return (Settings.movementFix != null && Settings.movementFix.isToggled() || this.forceMovementFix) && this.setRotations;
    }

    public static double getDirection(float rotationYaw, double moveForward, double moveStrafing) {
        if (moveForward < 0.0) {
            rotationYaw += 180.0f;
        }
        float forward = 1.0f;
        if (moveForward < 0.0) {
            forward = -0.5f;
        } else if (moveForward > 0.0) {
            forward = 0.5f;
        }
        if (moveStrafing > 0.0) {
            rotationYaw -= 90.0f * forward;
        }
        if (moveStrafing < 0.0) {
            rotationYaw += 90.0f * forward;
        }
        return Math.toRadians(rotationYaw);
    }

    public static RotationHelper get() {
        return INSTANCE;
    }

    public void setRotations(float yaw, float pitch) {
        this.serverYaw = Float.valueOf(yaw);
        this.serverPitch = Float.valueOf(pitch);
        this.setRotations = true;
    }

    public void setYaw(float yaw) {
        this.serverYaw = Float.valueOf(yaw);
        this.setRotations = true;
    }

    public void setPitch(float pitch) {
        this.serverPitch = Float.valueOf(pitch);
        this.setRotations = true;
    }
}

